/* Asset.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "Asset.h"

#import <Foundation/Foundation.h>

@implementation Asset

- (id)init
{
    [super init];
    [self setName:@""];
    return self;
}

- (void)dealloc
{
    [name release];
    [super dealloc];
}

- (id)initWithCoder:(NSCoder *)coder
{
    NSString *newName;

    newName = [coder decodeObject];
    [self setName:newName];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)coder
{
    [coder encodeObject:name];
}


- (void)setName:(NSString *)aName
{
    [name autorelease];
    name = [aName copy];
}

- (NSString *)name
{
    return name;
}


- (double)value
{
    return 0.0;
}

@end
