/* Portfolio.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "Portfolio.h"

#import <Foundation/Foundation.h>
#import "Asset.h"

@implementation Portfolio

- (id)init
{
    [super init];
    assets = [[NSMutableArray alloc] init];
    return self;
}

- (void)dealloc
{
    [assets release];
    [super dealloc];
}

- (id)initWithCoder:(NSCoder *)coder
{
    [assets autorelease];
    assets = [[coder decodeObject] retain];
    return self;
}

- (void)encodeWithCoder:(NSCoder *)coder
{
    [coder encodeObject:assets];
}


- (void)addAsset:(Asset *)anAsset
{
    [assets addObject:anAsset];
}

- (void)removeAsset:(Asset *)anAsset
{
    [assets removeObject:anAsset];
}

- (void)removeAssetAtIndex:(int)index
{
    [assets removeObjectAtIndex:index];
}

- (Asset *)assetAtIndex:(int)index
{
    Asset *theAsset;

    theAsset = [assets objectAtIndex:index];
    return theAsset;
}


- (int)numberOfAssets
{
    return (int)[assets count];
}


- (NSArray *)assets
{
    NSArray *returnedArray;

    returnedArray = [[NSArray alloc] initWithArray:assets];
    [returnedArray autorelease];
    return returnedArray;
}


- (double)value
{
    NSEnumerator *assetEnumerator;
    Asset *anAsset;
    double totalValue;

    totalValue = 0.0;
    assetEnumerator = [assets objectEnumerator];
    while (anAsset = [assetEnumerator nextObject]) {
        totalValue = totalValue + [anAsset value];
    }
    return totalValue;
}

@end
