/* DocController.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "DocController.h"
#import "AppController.h"

@implementation DocController

// This is a private method to offset the new window from the previous one
- (void)_staggerWindow
{
    static NSPoint nextTopLeft = { 0, 0 };

    if (nextTopLeft.x == 0 && nextTopLeft.y == 0)
    {
        // First time around use the default frame from the nib
        NSRect frame = [window frame];
        frame.origin.y += frame.size.height;
        nextTopLeft = frame.origin;
    }

    [window setFrameTopLeftPoint:nextTopLeft];
    nextTopLeft = [window cascadeTopLeftFromPoint:nextTopLeft];
}

- (id)init
{
    static int number = 0;
    NSString *nib = @"Document";

    self = [super init];
    if ([NSBundle loadNibNamed:nib owner:self])
    {
        [self _staggerWindow];
        [self setTitle:[NSString stringWithFormat:@"UNTITLED%d", number++]];
        [self show:self];
    }
    else
    {
        NSLog(@"DocController: unable to load %@.nib", nib);
        [self release];
        return nil;
    }
    return self;
}

- (void)dealloc
{
    // else the window might try asking us something
    [window setDelegate:nil];
    [super dealloc];
}

- (void)modify:(id)sender
{
    [self setDocumentEdited:YES];
    NSLog(@"Doc modified.");
}

- (NSString *)title
{
    return [window title];
}

- (void)setTitle:(NSString *)newTitle
{
    [window setTitle:newTitle];
}

- (BOOL)isDocumentEdited
{
    return [window isDocumentEdited];
}

- (void)setDocumentEdited:(BOOL)isEdited
{
    [window setDocumentEdited:isEdited];
}

- (BOOL)windowShouldClose:(id)sender
{
    // We should check for document modifications here, prior to
    // closing the document
    if ([self isDocumentEdited])
    {
        int ret;
        [window makeKeyAndOrderFront: nil];
        ret = NSRunAlertPanel(@"Close",
                              @"Save changes to %@?",
                              @"Save",
                              @"Don't Save",
                              @"Cancel",
                              [window title]
                              );
        switch(ret)
        {
            case NSAlertDefaultReturn:
                [self save:self];
                break;
            case NSAlertAlternateReturn:
                break;
            case NSAlertOtherReturn:
                return NO;
        }
    }

    // proceed with closure
    [[NSApp delegate] unregisterDocument:self];
    return YES;
}

- (void)show:(id)sender
{
    [window makeKeyAndOrderFront:self];
}

- (void)save:(id)sender
{
    NSLog(@"Doc saved.");
}

- (void)close:(id)sender
{
    [window performClose:sender];
}

@end
