/* ExpenseDataSource.h
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import <AppKit/AppKit.h>


@interface ExpenseDataSource : NSObject
{
    NSMutableArray *array;
    id tableView;
    id addButton;
    id deleteButton;
}

- (id)init;
- (void)dealloc;

- (void)awakeFromNib;

- (void)setArray:(NSMutableArray *)theArray;
- (NSMutableArray *)array;

- (id)selectedObject;

// TableView DataSource methods
- (int)numberOfRowsInTableView:(NSTableView *)tableView;
- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row;
- (void)tableView:(NSTableView *)tableView setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row;

- (void)add:(id)sender;
- (void)delete:(id)sender;

- (void)tableViewSelectionDidChange:(NSNotification *)notification;

@end