/* Categories.m
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import "Categories.h"

// Our own copy of the string to avoid making Expense.h a project header
// (which would work too)
static NSString *defaultNewCategory = @"defaultNewCategory";

@implementation Categories

- (void)awakeFromNib
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [category setStringValue:[defaults stringForKey:defaultNewCategory]];
    [super awakeFromNib];
}

- (void)change:(id)sender
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [defaults setObject:[category stringValue] forKey:defaultNewCategory];
    // Save to disk and broadcast change notification
    [defaults synchronize];
}

@end
