
#import "FindPanel.h"
#import "StringFinder.h"

@implementation FindPanel

- (void)setTextFromPasteboard
{
    NSPasteboard *pb = [NSPasteboard pasteboardWithName: NSFindPboard];
    NSString *string;

    if ([[pb types] containsObject: NSStringPboardType]) {
        string = [pb stringForType:NSStringPboardType];
        if (string && [string length])
            [text setStringValue:string];
    }
}

- (void)setPasteboardFromText
{
    NSPasteboard *pb = [NSPasteboard pasteboardWithName: NSFindPboard];
    NSString *string = [text stringValue];

    if (string && [string length]) {
        [pb declareTypes: [NSArray arrayWithObject: NSStringPboardType] owner:self];
        [pb setString: string forType:NSStringPboardType];
    }
}

- (id)responder
{
    return [[NSApp mainWindow] firstResponder];
}

- (void)setFound: (BOOL)value
{
        if (found = value)
                [status setTextColor: [NSColor lightGrayColor]];
        else {
                NSBeep();
                [status setTextColor: [NSColor darkGrayColor]];
                [text selectText: nil];
        }
}

- (BOOL)found
{
        return found;
}

- (void)show:(id)sender
{
    if (!panel) {
        if (![NSBundle loadNibNamed: @"FindPanel" owner: self]) {
            NSLog(@"Unable to load nib '%@'\n",@"Find");
            return;
        }
        // auto save frame stuff
        [panel setFrameAutosaveName:@"Find"];
        [panel setFrameUsingName:[panel frameAutosaveName]];
        [[NSNotificationCenter defaultCenter] addObserver: self
            selector: @selector(applicationDidBecomeActive:)
            name: NSApplicationDidBecomeActiveNotification
            object: NSApp];
    }
    [self setFound: YES];
    [panel makeKeyAndOrderFront: nil];
    [self setTextFromPasteboard];
    [text selectText:nil];
}

- (void)hide:(id)sender
{
    [panel orderOut: nil];
}

- (void)newText:(id)sender
{
    [self setPasteboardFromText];
    [nextButton performClick: nil];
    // fancy
    if ([self found])
        [self hide: nil];
}

- (void)findWithDirection:(int)direction
{
    id responder = [self responder];
    if (responder && [responder conformsToProtocol: @protocol(StringFinder)]) {
        if ([responder findString: [text stringValue] direction: direction wrap: YES]) {
            [self setFound: YES];
            return;
        }
    }
    [self setFound: NO];
}

- (void)next:(id)sender
{
    [self findWithDirection: 1];
}

- (void)previous:(id)sender
{
    [self findWithDirection: 0];
}

- (void)enterText:(id)sender
{    
    id responder = [self responder];
    if (responder && [responder conformsToProtocol: @protocol(StringFinder)]) {
        [text setStringValue: [responder selectedString]];
        [self setPasteboardFromText];
    }
    NSBeep();
}

- (void)applicationDidBecomeActive:(NSNotification *)notification
{
    [self setTextFromPasteboard];
}

@end
