/* DocController.h
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed
 * or implied, as to its fitness for any particular use.
 */

#import <AppKit/AppKit.h>

@interface DocController : NSObject
{
    id window;
    id dataSource;
    id sortingDataSource;
}

+ (NSString *)filenameFromOpen;
- (id)init;
- (id)initFromFile:(NSString *)file;
- (void)dealloc;

- (NSString *)title;
- (void)setTitle:(NSString *)newTitle;
- (NSString *)filename;
- (void)setFilename:(NSString *)newTitle;
- (BOOL)isDocumentEdited;
- (void)setDocumentEdited:(BOOL)isEdited;
- (BOOL)isNew;
- (id)dataSource;

// Window delegation/notification
- (BOOL)windowShouldClose:(id)sender;

// target/action
- (void)show:(id)sender;
- (void)save:(id)sender;
- (void)saveAs:(id)sender;
- (void)autosave:(id)sender;
- (void)close:(id)sender;
- (void)revert:(id)sender;

// Menu updating/validation
- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem;

@end
