/* SortingDataSource.h
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import <AppKit/AppKit.h>

// Notifications
extern NSString *SortingDataSourceDidSort;
extern NSString *SortingDataSourceSortColumnChanged;
extern NSString *sortByDefaultName;

@interface SortingDataSource : NSObject
{
    id tableView;
    id dataSource;
    NSMutableArray *rows;
    NSTableColumn *sortByColumn;
    BOOL isSortNeeded;
}

- (id)initWithDataSource:(id)theDataSource;
- (id)init;
- (void)dealloc;

- (void)defaultsChanged:(NSUserDefaults *)defaults;
- (void)defaultsDidChangeNotification:(NSNotification *)notification;
- awakeFromNib;

- (void)setDataSource:(id)theDataSource;
- (id)dataSource;

- (void)setSortByColumn:(NSTableColumn *)aColumn;
- (NSTableColumn *)sortByColumn;
- (void)sortBy:(id)sender;
- (void)sort:(id)sender;

- (NSTableView *)tableView;

// TableView facade methods
- (void)reloadData;
- (int)selectedRow;
- (void)selectRow:(int)row byExtendingSelection:(BOOL)extend;

// TableView DataSource facade methods
- (int)numberOfRowsInTableView:(NSTableView *)tableView;
- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row;
- (void)tableView:(NSTableView *)tableView setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row;

    // TableView delegate facade methods
- (void)tableViewColumnDidMove:(NSNotification *)notification;
- (void)tableViewColumnDidResize:(NSNotification *)notification;
- (void)tableViewSelectionDidChange:(NSNotification *)notification;
- (void)tableView:(NSTableView *)tableView willDisplayCell:(id)cell forTableColumn:(NSTableColumn *)tableColumn row:(int)row;
- (BOOL)tableView:(NSTableView *)tableView shouldEditTableColumn:(NSTableColumn *)tableColumn row:(int)row;
- (BOOL)selectionShouldChangeInTableView:(NSTableView *)aTableView;
- (BOOL)tableView:(NSTableView *)tableView shouldSelectRow:(int)row;
- (BOOL)tableView:(NSTableView *)aTableView shouldSelectTableColumn:(NSTableColumn *)tableColumn;

@end
