/* ExpenseDataSource.h
 *
 * You may freely copy, distribute and reuse the code in this example.
 * Apple Computer, Inc. disclaims any warranty of any kind, expressed or implied, as to
 * its fitness for any particular use.
 */

#import <AppKit/AppKit.h>


@interface ExpenseDataSource : NSObject
{
    id tableView;
    id addButton;
    id deleteButton;
    NSMutableArray *rows;
}

- (id)init;
- (void)dealloc;

- (void)awakeFromNib;

- (void)setArray:(NSMutableArray *)theArray;
- (NSMutableArray *)array;
- (NSTableView *)tableView;

// TableView DataSource methods
- (int)numberOfRowsInTableView:(NSTableView *)tableView;
- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row;
- (void)tableView:(NSTableView *)tableView setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row;

// TableView editing target/action methods
- (void)add:(id)sender;
- (void)delete:(id)sender;

@end