#import "Inspector.h"
#import "ExpenseDataSource.h"
#import "Expense.h"

@implementation Inspector

static NSString *nib = @"Inspector";

- (id)init
{
    self = [super init];
    if (![NSBundle loadNibNamed:nib owner:self])
    {
        NSLog(@"Unable to load %@.nib", nib);
        [self release];
        return nil;
    }
    return self;
}

// target/action
- (void)show:(id)sender
{
    [panel makeKeyAndOrderFront:self];
}

// Look up the object under inspection
- (id)_inspectedObject
{
    id mainWindow = [NSApp mainWindow];

    if (mainWindow)
    {
        id dataSource = [[mainWindow delegate] dataSource];

        if (dataSource)
        {
            return [dataSource selectedObject];
        }
    }
    return nil;
}

- (void)billableChanged:(id)sender
{
    id	selectedObject = [self _inspectedObject];
    if (selectedObject)
    {
        [selectedObject setIsBillable:[billableSwitch state]];
        // We have modified the document
        [[NSApp mainWindow] setDocumentEdited:YES];
    }
}

// This method is invoked by virtue of our being a window delegate.
// If the window (panel) is not visible, it will not receive the update
// and so we don't get called, which is the behaviour we want.

- (void)windowDidUpdate:(NSNotification *)notification
{
    id	selectedObject = [self _inspectedObject];
    if (selectedObject)
    {
        [billableSwitch setState:[selectedObject isBillable]];
        [panel setTitle:[selectedObject category]];
    }
    else
    {
        [billableSwitch setState:0];
        [panel setTitle:@"Nothing to inspect"];
    }
}

@end
