#import "Categories.h"
#import "AlphaFormatter.h"

// Our own copy of the string to avoid making Expense.h a project header
// (which would work too)
static NSString *defaultNewCategory = @"defaultNewCategory";

@implementation Categories

- (void)awakeFromNib
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [category setStringValue:[defaults stringForKey:defaultNewCategory]];
    // attach the alpha formatter here too!
    {
        AlphaFormatter *formatter = [[AlphaFormatter alloc] init];
        [formatter setCapitalize: YES];
        // category is already a cell (?)
        [category setFormatter: formatter];
    }
    [super awakeFromNib];
}

- (void)change:(id)sender
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [defaults setObject:[category stringValue] forKey:defaultNewCategory];
    // Save to disk and broadcast change notification
    [defaults synchronize];
}

@end
