/* FoundationAdditions.m created by lindberg on Mon 20-Dec-1999 */
/*-
 * Copyright (c) 2000
 *      Blacksmith, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Blacksmith, Inc.
 * 4. The name Blacksmith may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY BLACKSMITH ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL BLACKSMITH BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import "FoundationAdditions.h"
#import <Foundation/NSPathUtilities.h>
#import <Foundation/NSDate.h>
#import <EOControl/EOKeyValueCoding.h>

@interface NSObject (WarningAvoidance)
- (NSString *)name;  // method on EOAttribute/EOEntity etc.
@end

@implementation NSArray (EOGenerator)

- (NSArray *)reversedArray
{
    return [[self reverseObjectEnumerator] allObjects];
}

// does an @reversedArray KeyValue key
- (id)computeReversedArrayForKey:(NSString *) key
{
    if ([key length] == 0)
        return [self reversedArray];
    else
        return [[self reversedArray] valueForKeyPath:key];
}

static int sortByName(id obj1, id obj2, void *context)
{
    return [(NSString *)[obj1 name] compare:[obj2 name]];
}

// does an @sortedNameArray KeyValue key
- (id)computeSortedNameArrayForKey:(NSString *)key
{
    if ([key length] == 0)
        return [self sortedArrayUsingFunction:sortByName context:NULL];
    else
        return [[self sortedArrayUsingFunction:sortByName context:NULL] valueForKeyPath:key];
}

// does an @sortedStringArray KeyValue key
- (id)computeSortedStringArrayForKey:(NSString *)key
{
    if ([key length] == 0)
        return [self sortedArrayUsingSelector:@selector(compare:)];
    else
        return [[self sortedArrayUsingSelector:@selector(compare:)] valueForKeyPath:key];
}

@end

@implementation NSString (EOGenerator)

- (NSString *)initialCapitalString
{
    NSRange  firstLetterRange;
    NSString *firstLetterString;
    NSString *restOfString;

    if ([self length] == 0) return self;

    firstLetterRange  = [self rangeOfComposedCharacterSequenceAtIndex:0];
    firstLetterString = [[self substringWithRange:firstLetterRange] uppercaseString];
    restOfString      = [self substringFromIndex:NSMaxRange(firstLetterRange)];

    return [firstLetterString stringByAppendingString:restOfString];
}

@end

@implementation NSFileManager (EOGenerator)

- (BOOL)directoryExistsAtPath:(NSString *)path
{
    BOOL isDir = NO;
    BOOL isFile = [self fileExistsAtPath:path isDirectory:&isDir];
    return (isFile && isDir);
}

- (BOOL)regularFileExistsAtPath:(NSString *)path
{
    BOOL isDir = NO;
    BOOL isFile = [self fileExistsAtPath:path isDirectory:&isDir];
    return (isFile && !isDir);
}

- (NSString *)findFile:(NSString *)filename inSearchPath:(NSArray *)paths
{
    int i, count = [paths count];

    for (i=0; i<count; i++)
    {
        NSString *currPath = [paths objectAtIndex:i];
        NSString *fullPath = [currPath stringByAppendingPathComponent:filename];

        if ([self regularFileExistsAtPath:fullPath])
            return fullPath;
    }

    return nil;
}

- (void)touchPath:(NSString *)filePath
{
    NSMutableDictionary *attributes;

    attributes = [[NSMutableDictionary alloc] initWithCapacity:1];
    [attributes setObject:[NSDate date] forKey:NSFileModificationDate];
    [self changeFileAttributes:attributes atPath:filePath];
    [attributes release];
}

@end
