/*
 *  cc_cksum.c
 *
 *  Credit Card check sum program
 *  from 2600 magazine.
 *
 */

#include <stdio.h>


void
main(void) {

    char cc[20];
    int check, len, prod, j;
    printf("\nAmex/MC/Visa Checksum Verification Program");
    for (; ;) {
        printf("\nEnter Card Number [w/o spaces or dashes] (Q to quit)\n");
        scanf("%s", cc);
        if (cc[0] == 'Q' || cc[0] == 'q') {
            exit(0);
        }
        if (cc[0] != '3' && cc[0] != '4' && cc[0] != '5' && cc[0] != '6') {
            printf("Card number must start with 3, 4, 5, or 6\n");
            continue;
        }
        len = strlen(cc);
        if (cc[0] == '5' && len != 16) {
            printf("Mastercard must be 16 digits\n");
            continue;
        }
        if (cc[0] == '4' && (len != 13 && len != 16)) {
            printf("Visa numbers must be 13 or 16 digits\n");
            continue;
        }
        if (cc[0] == '3' && len != 15) {
            printf("American Express Numbers must be 15 digits\n");
            continue;
        }
        if (cc[0] == '6' && len != 16) {
            printf("Discover Numbers must be 16 digits\n");
            continue;
        }
        /*  Perform checksum - Weighing list 212121212121... */
        check = 0;
        for (j = 0; j < len; ++j) {
            prod = cc[j] - '0';
            if (((len - (j + 1)) %2)) {
                prod *= 2;
            }
            if (prod >= 10) {
                prod = prod - 9;
            }
            check += prod;
        }
        if ((check % 10) == 0) {
            printf("Card has good checksum\n");
        } else {
            printf("Card has BAD checksum\n");
        }
    }
}
