######################################################################
#
# IMPORTANT: before you run 'make', you need to enter one of these two
# lines (depending on your shell):
#	 DYLD_LIBRARY_PATH=`pwd`; export DYLD_LIBRARY_PATH
# or
#	setenv DYLD_LIBRARY_PATH `pwd`
#
######################################################################

# Posix support has been removed from OpenStep 
#
useposix='undef'

libpth=''
libswanted=' '
libc='/NextLibrary/Frameworks/System.framework/System'

ldflags='-u _objc_msgSend'
lddlflags='-bundle -undefined suppress'
ccflags='-fno-common -DUSE_NEXT_CTYPE -DRHAPSODY'
cccdlflags='none'
ld='cc'
optimize='-g -O'
pp_sys_cflags='ccflags="$ccflags -DHAS_TELLDIR_PROTOTYPE"'

useshprlib='true'
dlext='bundle'
dlsrc='dl_rhapsody.xs'
so='dylib'

case "$prefix" in
'') prefix='/NextLibrary/Frameworks/Perl.framework' ;;
esac

archname='none'
mydomain='apple.com'

d_strcoll='undef'
i_dbm='define'
i_utime='undef'
groupstype='int'
direntrytype='struct direct'

usemymalloc='n'
clocktype='int'

bincompat3='n'
libperl='Perl'

archlib='/NextLibrary/Frameworks/Perl.framework/Modules'
archlibexp='/NextLibrary/Frameworks/Perl.framework/Modules'

######################################################################
# MAB support
######################################################################
# By default we will build for all architectures your development
# environment supports. If you only want to build for the platform
# you are on, simply comment or remove the line below.
#
# If you want to build for specific architectures, change the line
# below to something like
#
#	archs=(m68k i386)
#
archs=`/bin/lipo -info /NextLibrary/Frameworks/System.framework/System | sed 's/^[^:]*:[^:]*: //'`
for arch in $archs
do
    archflags="$archflags -arch $arch"
done
ccflags="$ccflags $archflags"
ldflags="$ldflags $archflags"
lddlflags="$lddlflags $archflags"

######################################################################
# END MAB support
######################################################################
