/* pref.h
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Copyright (c) 1992, 1993, 1994, 1995, 1996, 1997 by Mike Gleason, NCEMRSoft.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, without modification,
 * are permitted.
 * 
 */

#define kFirewallPrefFileName			"firewall"
#define kPrefFileName				"prefs"
#define kFirstFileName				"v3init"

typedef void (*PrefProc)(int i, const char *const, FILE *const fp);
typedef struct PrefOpt {
	const char *varname;
	PrefProc proc;
	int visible;
} PrefOpt;

#define kPrefOptObselete (-1)
#define kPrefOptInvisible 0
#define kPrefOptVisible 1

#define PREFOBSELETE (PrefProc) 0, kPrefOptObselete,

/* pref.c */
void SetAnonPass(int, const char *const, FILE *);
void SetConfirmClose(int, const char *const, FILE *);
void SetConnTimeout(int, const char *const, FILE *);
void SetCtrlTimeout(int, const char *const, FILE *);
void SetPager(int, const char *const, FILE *);
void SetPassive(int, const char *const, FILE *);
void SetProgressMeter(int, const char *const, FILE *);
void SetSavePasswords(int, const char *const, FILE *);
void SetXferTimeout(int, const char *const, FILE *);
void Set(const char *const, const char *const);
void LoadPrefs(void);
void InitPrefs(void);
void PostInitPrefs(void);
void SavePrefs(void);
void WriteDefaultFirewallPrefs(FILE *);
void LoadFirewallPrefs(void);
void CheckForNewV3User(void);
