/*+++*
 *  title:	compat.h
 *  abstract:	OPENSTEP/Rhapsody compatibility definitions for mailapp-utilities. 
 *  author:	Tom Hageman <tom@basil.icce.rug.nl>
 *  created:	January 1998
 *  modified:	(see RCS Log at end)
 *  copyleft:
 *
 *	Copyright (C) 1998 Tom R. Hageman, but otherwise perfect freeware.
 *
 *  description:
 *
 *---*/

#ifdef RCS_compat_ID
static const char * const RCS_h_id = ((void)&RCS_h_id,
	"@(#)compat.h,v 1.8 1998/10/30 21:49:39");
#endif

#if (defined(__APPLE_CC__))
#  define RHAPSODY   2
#elif (!defined(NS_TARGET) && !defined(NeXT))
#  warning Cannot determine NEXTSTEP/OPENSTEP/Rhapsody version.
#elif (NS_TARGET < 40)
#  define NEXTSTEP   1
#elif (NS_TARGET <= 41)
#  define OPENSTEP   1
#else /* Rhapsody(DR1) */
#  define RHAPSODY   1
#endif

#if (OPENSTEP || RHAPSODY)

#import <Foundation/Foundation.h>
#import <objc/objc.h>
#import <objc/objc-runtime.h>

extern const char *NXGetDefaultValue(const char *owner, const char *name);

#define NXCopyStringBufferFromZone(str, zone) \
   ((str) ? strcpy(NSZoneMalloc((zone), strlen(str)+1), (str)) : NULL)

#define NXCopyStringBuffer(str) NXCopyStringBufferFromZone((str), NULL)

#  define POOL_INIT	id _pool = [[NSAutoreleasePool alloc] init];
#  define POOL_RELEASE	[_pool release];

#  define ROOT_OBJECT	NSObject
#  define FREE_OBJECT(o) [(o) release]

#else // NEXTSTEP

#import <objc/Object.h>
#import <defaults/defaults.h>

#  define POOL_INIT
#  define POOL_RELEASE

#  define ROOT_OBJECT	Object
#  define FREE_OBJECT(o) [(o) free]

#endif


/* Some generic compiler-dependent stuff I couldn't find a better place for. */

#if __GNUC__ && __GNUC_MAJOR__ >= 2
# if __GNUC_MINOR >= 7
#  define __ATTRIBUTE_CONST__ __attribute__((const))
# elif __GNUC_MINOR__ >= 5
#  define __ATTRIBUTE_CONST__ const
# endif
#endif
#ifndef __ATTRIBUTE_CONST__
# define __ATTRIBUTE_CONST__
#endif
