/* -*-C-*-
*******************************************************************************
*
* File:         mailtoc.h
* RCS:          /usr/local/sources/CVS/mailapp-utilities/mailtoc.h,v 1.13 1999/04/26 15:06:30 tom Exp
* Description:  Structure and access routine declarations for Mail.app mailboxes
* Author:       Carl Edman
* Created:      Sun Apr 25 10:25:29 1993
* Modified:     Sun Jul 19 23:25:53 1998 Tom Hageman <tom@basil.icce.rug.nl>
* Language:     C
* Package:      EnhanceMail / mailapp-utilities
* Status:       
*
* (C) Copyright 1993, but otherwise this file is perfect freeware.
*
*******************************************************************************
*/

#if (NS_TARGET_MAJOR < 4 && !defined(__APPLE_CC__)) /* NEXTSTEP */
#  import <appkit/graphics.h>
#else /* OPENSTEP/Rhapsody(DR1/DR2) */
#  import <Foundation/NSGeometry.h>
#  define NXCoord   float
#  define NXRect    NSRect
#endif

#import <stdio.h>
#import <time.h>

/* The following two structures have been stolen from Chris Paris excellent
   exposition of the NeXT mailbox format.
   ints and floats are assumed 32-bits; stored on disk as native m68k (big-endian) */

struct table_of_contents_header
{
   int magic;           /* magic number: 890712 (NS/OS/RDR), 900000 (MOSXS) */
   int num_msgs;        /* number of messages in mbox */
   time_t mbox_time;    /* the m_time of mbox */
   NXCoord list;        /* height of upper section of split view containing list */
   NXRect window;       /* Mail window */
};

struct message_index
{
   int record_length;   /* the length of this record, including this word */
   int mes_offset;      /* offset in mbox where this message begins */
   int mes_length;      /* length in bytes of this message in mbox */
   int mes_date;        /* the date of this message */
   char status;         /* read ' ' or '>', unread '*', deleted 'd' or 'D', flagged '+' */
   char msgtype;        /* regular ' ', NeXT mail 'r'/'n' or Mime Mail 'm', Mime/HTML 'h' */
   char encrypted;      /* Is this message encrypted 'e' or not ' '? */
   char sync;           /* always ' ' */
   char data[0];
   /* variable-length data:
      asciiz - From: (in NeXT encoding for NS/OS/RDR1, MacRoman encoding as of RDR2/MOSXS)
      asciiz - Subject: (ditto)
      asciiz - attachment filename - no attachment if empty string.
      int - attachment size.
      int - attachment time_t in NS/OS/RDR1; always 0 in RDR2/MOSXS.
      int - priority
      int - (optional) message time_t (new in RDR2/MOSXS.)
    */
};

struct table_of_contents_header *get_table_of_contents_header(FILE *f,int createflag);
struct message_index *get_message_index(FILE *f);

char *message_from(const struct message_index *mi);
char *message_subject(const struct message_index *mi);
char *message_reference(const struct message_index *mi);

time_t message_time(const struct message_index *mi);
int message_attachsize(const struct message_index *mi);
time_t message_attachtime(const struct message_index *mi);
int message_priority(const struct message_index *mi);

time_t message_set_time(struct message_index *mi,time_t time);
int message_set_attachsize(struct message_index *mi,int size);
time_t message_set_attachtime(struct message_index *mi,time_t time);
int message_set_priority(struct message_index *mi,int priority);

long message_current_date(void);
long message_date(int year, const char *month, int day);

void message_get_date(const struct message_index *mi, int *year, int *month, int *day);
int message_age(const struct message_index *mi);
   /* age in days. */

int put_message_index(FILE *f,struct message_index *mi);
int put_table_of_contents_header(FILE *f,struct table_of_contents_header *toc);

#if _MAILTOC_DEFINES
#  define MT_UNSET		' '
#  define MT_STATUS_READ_1	MT_UNSET
#  define MT_STATUS_READ_2	'>'
#  define MT_STATUS_READ_3	'<'
#  define MT_STATUS_READ	MT_STATUS_READ_1
#  define MT_STATUS_NEW		'*'
#  define MT_STATUS_DELETED_1	'd'
#  define MT_STATUS_DELETED_2	'D'
#  define MT_STATUS_DELETED	MT_STATUS_DELETED_1
#  define MT_STATUS_UNREAD_1	'u'
#  define MT_STATUS_UNREAD_2	'U'
#  define MT_STATUS_UNREAD	MT_STATUS_UNREAD_1
#  define MT_STATUS_FLAGGED	'+'

#  define MT_TYPE_ASCII		MT_UNSET
#  define MT_TYPE_NEXT_1	'r' /* NEXTSTEP/OPENSTEP */
#  define MT_TYPE_NEXT_2	'n' /* (alleged) Rhapsody */
#  define MT_TYPE_NEXT		MT_TYPE_NEXT_1
#  define MT_TYPE_MIME		'm'
#  define MT_TYPE_HTML		'h' /* MacOS X only */

#  define MT_ENCRYPTED		'e'
#endif

#define MBOX_TOC_MAGIC		890712
#define MBOX_TOC_MAGIC_MACOS_X	900000

/* Ugh! Apple saw fit to change the magic number for MacOS X (Server).
   (I guess that's what hacking directly into undocumented file formats
    makes fun:-) */

#define MBOX_CONTENTS_FILE	"mbox"
#define MBOX_TOC_FILE		"table_of_contents"

#define MBOX_INDEX_FILE		"content.store"	/* EnhanceMail extension. */
