/*+++*
 *  title:	timestamp.c
 *  abstract:	Implementation of timestamp functions for mailapp-utilities.
 *  author:	Tom Hageman <tom@basil.icce.rug.nl>
 *  created:	November 1998 -- extracted from appnmail
 *  modified:	
 *  copyleft:
 *
 *	Copyright (C) 1998  Tom R. Hageman, but otherwise perfect freeware.
 *
 *  description:
 *	(see corresponding *.h file)
 *---*/

#ifdef RCS_ID
static const char * const RCSid = ((void)&RCSid,
	"@(#)timestamp.c,v 1.1 1998/11/20 17:29:20");
#define RCS_TIMESTAMP_ID
#endif

#include "timestamp.h"
#include <string.h>
#include <stdlib.h>


int timezone_to_gmtoff(const char *timezone)
{
   /* The symbolic timezone table, snarfed/adapted from getdate.y. */
   static const struct { const char *name; int offset; } table[] = {
      { "gmt",	    0		},	/* Greenwich Mean */
      { "ut",	    0		},	/* Universal (Coordinated) */
      { "utc",	    0		},
      { "wet",	    0		},	/* Western European */
      { "bst",	    0	+ 100	},	/* British Summer */
      { "wat",	 -100		},	/* West Africa */
      { "at",	 -200		},	/* Azores */
#if 0
      /* For completeness.  BST is also British Summer, and GST is
       * also Guam Standard. */
      { "bst",	 -300		},	/* Brazil Standard */
      { "gst",	 -300		},	/* Greenland Standard */
#endif
#if 1
      { "nft",	 -330		},	/* Newfoundland */
      { "nst",	 -330		},	/* Newfoundland Standard */
      { "ndt",	 -330	+ 100	},	/* Newfoundland Daylight */
#endif
      { "ast",	 -400		},	/* Atlantic Standard */
      { "adt",	 -400	+ 100	},	/* Atlantic Daylight */
      { "est",	 -500		},	/* Eastern Standard */
      { "edt",	 -500	+ 100	},	/* Eastern Daylight */
      { "cst",	 -600		},	/* Central Standard */
      { "cdt",	 -600	+ 100	},	/* Central Daylight */
      { "mst",	 -700		},	/* Mountain Standard */
      { "mdt",	 -700	+ 100	},	/* Mountain Daylight */
      { "pst",	 -800		},	/* Pacific Standard */
      { "pdt",	 -800	+ 100	},	/* Pacific Daylight */
      { "yst",	 -900		},	/* Yukon Standard */
      { "ydt",	 -900	+ 100	},	/* Yukon Daylight */
      { "hst",	-1000		},	/* Hawaii Standard */
      { "hdt",	-1000	+ 100	},	/* Hawaii Daylight */
      { "cat",	-1000		},	/* Central Alaska */
      { "ahst",	-1000		},	/* Alaska-Hawaii Standard */
      { "nt",	-1100		},	/* Nome */
      { "idlw",	-1200		},	/* International Date Line West */
      { "cet",	  100		},	/* Central European */
      { "met",	  100		},	/* Middle European */
      { "mewt",	  100		},	/* Middle European Winter */
      { "mest",	  100	+ 100	},	/* Middle European Summer */
      { "mesz",	  100	+ 100	},	/* Middle European Summer */
      { "swt",	  100		},	/* Swedish Winter */
      { "sst",	  100	+ 100	},	/* Swedish Summer */
      { "fwt",	  100		},	/* French Winter */
      { "fst",	  100	+ 100	},	/* French Summer */
      { "eet",	  200		},	/* Eastern Europe, USSR Zone 1 */
      { "bt",	  300		},	/* Baghdad, USSR Zone 2 */
#if 1
      { "it",	  330		},	/* Iran */
#endif
      { "zp4",	  400		},	/* USSR Zone 3 */
      { "zp5",	  500		},	/* USSR Zone 4 */
#if 1
      { "ist",	  530		},	/* Indian Standard */
#endif
      { "zp6",	  600		},	/* USSR Zone 5 */
#if 0
      /* For completeness.  NST is also Newfoundland Standard, and SST is
       * also Swedish Summer. */
      { "nst",	  630		},	/* North Sumatra */
      { "sst",	  700		},	/* South Sumatra, USSR Zone 6 */
#endif	/* 0 */
      { "wast",	  700		},	/* West Australian Standard */
      { "wadt",	  700	+ 100	},	/* West Australian Daylight */
#if 1
      { "jt",	  730		},	/* Java (3pm in Cronusland!) */
#endif
      { "cct",	  800		},	/* China Coast, USSR Zone 7 */
      { "jst",	  900		},	/* Japan Standard, USSR Zone 8 */
#if 1
      { "cast",	  930		},	/* Central Australian Standard */
      { "cadt",	  930	+ 100	},	/* Central Australian Daylight */
#endif
      { "east",	 1000		},	/* Eastern Australian Standard */
      { "eadt",	 1000	+ 100	},	/* Eastern Australian Daylight */
      { "gst",	 1000		},	/* Guam Standard, USSR Zone 9 */
      { "nzt",	 1200		},	/* New Zealand */
      { "nzst",	 1200		},	/* New Zealand Standard */
      { "nzdt",	 1200	+ 100	},	/* New Zealand Daylight */
      { "idle",	 1200		},	/* International Date Line East */
      {  NULL,	0		}
   };
   int t = 0;
   int sign = 1;

   if (*timezone == '+' || *timezone == '-')
   {
      t = atoi(&timezone[1]);
      if (*timezone == '-') sign = -1;
   }
   else
   {
      int i;

      for (i = 0;  table[i].name;  i++)
      {
	 if (strcasecmp(table[i].name, timezone) == 0)
	 {
	    t = table[i].offset;
	    if (t < 0)
	    {
	       t = -t;
	       sign = -1;
	    }
	    break;
	 }
      }
   }
   return (((t / 100) * 60 + (t % 100)) * 60) * sign;
}

time_t timestamp(int year, int month, int day, int hour, int min, int sec,
		 const char *timezone)
{
   struct tm tm;
   
   tm.tm_year = year - 1900;
   tm.tm_mon = month - 1;
   tm.tm_mday = day;
   tm.tm_hour = hour;
   tm.tm_min = min;
   tm.tm_sec = sec;
   tm.tm_gmtoff = timezone_to_gmtoff(timezone);
   tm.tm_isdst = 0;
   /* XXX Daylight savings time (non)handling is probably imperfect... */

   return mktime(&tm);
}
