/* textalign.c -- alignment mode for text for manual
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

cc -Wall -o textalign -I/usr/local/include textalign.c -lcpdf

*/


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <cpdflib.h>

static char *tposstr[] = {
  "TEXTPOS_LL", "TEXTPOS_LM", "TEXTPOS_LR",
  "TEXTPOS_ML", "TEXTPOS_MM", "TEXTPOS_MR",
  "TEXTPOS_UL", "TEXTPOS_UM", "TEXTPOS_UR"
};

void main(int argc, char *argv[])
{
int i;
float xlb = 0.5, xle = 6.5;
float ylb = 0.5, yle = 2.3;
float x = xlb+0.5;
float y = ylb+0.5;
float xbump = 2.5;
float ybump = 0.4;
float xp, yp;
float fontsize = 14.0;

    /* == Initialization == */
    cpdf_open(0);
    cpdf_enableCompression(YES);		/* use Flate/Zlib compression */
    cpdf_init();
    cpdf_pageInit(1, PORTRAIT, LETTER, LETTER);		/* page orientation */
    cpdf_translate(0.0, 7.0);

    cpdf_setlinewidth(0.15);
    cpdf_setdash("[1 2] 0");
    for(i=0; i<3; i++) {
	cpdf_moveto(xlb, y+ybump*(float)i);
	cpdf_lineto(xle, y+ybump*(float)i);
    }
    cpdf_stroke();
    for(i=0; i<3; i++) {
	cpdf_moveto(x+xbump*(float)i, ylb);
	cpdf_lineto(x+xbump*(float)i, yle);
    }
    cpdf_stroke();
    cpdf_nodash();

    cpdf_beginText(0);
    cpdf_setFont("Helvetica", "MacRomanEncoding", fontsize);
    for(i=0; i< 9; i++) {
	xp = x + (float)(i%3)*xbump;
	yp = y + (float)(i/3)*ybump;
        cpdf_textAligned(xp, yp, 0.0, i, tposstr[i]);	/* cpdf_text() may be repeatedly used */
    }
    cpdf_endText();

    cpdf_finalizeAll();			/* PDF file/memstream is actually written here */
    cpdf_savePDFmemoryStreamToFile("textalign.pdf");

    /* == Clean up == */
    cpdf_close();			/* shut down */
    cpdf_launchPreview();		/* launch Acrobat/PDF viewer on the output file */
}
