/* cpdfAnnot.c -- Text annotations and URL actions.
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "cpdflib.h"
#include "cglobals.h"

/****************************************************************************/
/* This function will enable and set Text Annotation for the PDF file */
/* Only the first 64 chars of title string will be used, the remainder will be truncated */
/* Call after cpdf_open(), but before cpdf_init() */

void cpdf_setAnnotation(float xll, float yll, float xur, float yur, char *title, char *annot) 
{
	cpdf_rawSetAnnotation( x_Domain2Points(xll), y_Domain2Points(yll),
			       x_Domain2Points(xur), y_Domain2Points(yur),
			       title, annot);
}

void cpdf_setActionURL(float xll, float yll, float xur, float yur, char *linkspec)
{
	cpdf_rawSetActionURL( x_Domain2Points(xll), y_Domain2Points(yll),
			      x_Domain2Points(xur), y_Domain2Points(yur),
			      linkspec);
}

int cpdf_includeTextFileAsAnnotation(float xll, float yll, float xur, float yur, char *title, char *filename)
{
	return( cpdf_includeTextFileAsAnnotation(
				x_Domain2Points(xll), y_Domain2Points(yll),
			      	x_Domain2Points(xur), y_Domain2Points(yur),
			      	title, filename) );
}

/* Raw coordinate versions */
void cpdf_rawSetAnnotation(float xll, float yll, float xur, float yur, char *title, char *annot) 
{
int i;
int foundInPageList = 0;	/* in pageInfos[].annotIdx[] */
char *ptr, *ptr2, ch;
int  escapecount = 0, newlncount = 0;
CPDFannotInfo *aI;
	aI = &annotInfos[numAnnots];
	aI->type = ANNOT_TEXT;
	aI->xLL = xll;
	aI->yLL = yll;
	aI->xUR = xur;
	aI->yUR = yur;

	/* Scan annotation string and determine how long the escaped string will be
	   by counting chars that require escaping, and # of newline chars. */
	ptr = annot;
	while( (ch = *ptr++) != '\0') {
	    if( (ch == '(') || (ch == ')') || (ch == '\\') ) escapecount++;
    	    if( (ch == '\n') || (ch == '\r') ) newlncount++;
	}

	/* Allocate sufficient string space */
	aI->content_link = (char *)malloc((size_t)(strlen(annot) + escapecount + newlncount*3 + 16));
	_cpdf_malloc_check((void *)aI->content_link);
	ptr = annot;
	ptr2 = aI->content_link;
	/* escape special chars \ and () for PS/PDF string */
	while( (ch = *ptr++) != '\0') {
	    if( (ch == '\\') || (ch == '(') || (ch == ')') ) {
		*ptr2++ = '\\';
		*ptr2++ = ch;
	    }
	    else if((ch == '\n') || (ch == '\r')) {
		*ptr2++ = '\\';
		*ptr2++ = 'r';
		*ptr2++ = '\\';
		*ptr2++ = 'n';		/* convert LF to CRLF for maximum compatibility */
	    }
	    else
		*ptr2++ = ch;
	}
	*ptr2 = '\0';
	aI->annot_title = (char *) malloc((size_t)(strlen(title) +1));
	_cpdf_malloc_check((void *)aI->annot_title);
	strcpy(aI->annot_title, title);
	/*  Store the index of this annotation in the list for the current page in pageInfos[]. */
	foundInPageList = 0;
	for(i=0; i < pageInfos[currentPage].npAnnot; i++) {
	    if(pageInfos[currentPage].annotIdx[i] == numAnnots)
		foundInPageList = 1;	/* we already used it on this page */
	}
	if(!foundInPageList)
	    pageInfos[currentPage].annotIdx[pageInfos[currentPage].npAnnot++] = numAnnots;
	numAnnots++;
}


void cpdf_rawSetActionURL(float xll, float yll, float xur, float yur, char *linkspec)
{
int i;
int foundInPageList = 0;
CPDFannotInfo *aI;
	aI = &annotInfos[numAnnots];
	aI->type = ANNOT_LINK;
	aI->xLL = xll;
	aI->yLL = yll;
	aI->xUR = xur;
	aI->yUR = yur;

	/* Allocate sufficient string space */
	aI->content_link = (char *)malloc((size_t)(strlen(linkspec) +1));
	_cpdf_malloc_check((void *)aI->content_link);
	aI->annot_title = NULL;
	strcpy(aI->content_link, linkspec);
	/*  Store the index of this link in the list for the current page in pageInfos[]. */
	foundInPageList = 0;
	for(i=0; i < pageInfos[currentPage].npAnnot; i++) {
	    if(pageInfos[currentPage].annotIdx[i] == numAnnots)
		foundInPageList = 1;
	}
	if(!foundInPageList)
	    pageInfos[currentPage].annotIdx[pageInfos[currentPage].npAnnot++] = numAnnots;
	numAnnots++;
}


int cpdf_rawIncludeTextFileAsAnnotation(float xll, float yll, float xur, float yur, char *title, char *filename)
{
int ch;
FILE *fp;
CPDFmemStream *memStream;
char *memBuffer;
int memLen, bufSize;
	if((fp = fopen(filename, "r")) == NULL) {
	    fprintf(stderr, "ClibPDF: cannot open annotation text file: %s\n", filename);
	    return(-1);
	}
	memStream = cpdf_openMemoryStream();
	while( (ch = fgetc(fp)) != EOF) {
	    if(ch == '\\' || ch == '(' || ch == ')')
		cpdf_memPutc('\\', memStream);		/* escape special chars */
            cpdf_memPutc(ch, memStream);
	}
	fclose(fp);
	cpdf_getMemoryBuffer(memStream, &memBuffer, &memLen, &bufSize);
	cpdf_rawSetAnnotation(xll, yll, xur, yur, title, memBuffer);
	cpdf_closeMemoryStream(memStream);
	return(0);
}


int  _cpdf_freeAllAnnotInfos(void)
{
int i;
CPDFannotInfo *aI;
	for(i=0; i<numAnnots; i++) {
	    aI = &annotInfos[i];
	    if(aI->content_link)
		free(aI->content_link);
	    if(aI->annot_title)
		free(aI->annot_title);
	}
	return(0);
}

