/* cpdfGstate.c  -- graphics state 
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

1998-07-09 [IO]
*/

#include "version.h"

#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "cpdflib.h"		/* This must be included before all other local include files */
#include "cglobals.h"


void cpdf_gsave(void)
{
    if(useContentMemStream)
	cpdf_memPuts("\nq\n", currentMemStream);
    else
	fprintf(fpcontent, "\nq\n");
}

void cpdf_grestore(void)
{
    if(useContentMemStream)
	cpdf_memPuts("Q\n", currentMemStream);
    else
	fprintf(fpcontent, "Q\n");
}

/* E.g., cpdf_setdash("[6 1 2 1] 0"); for 6 ON, 1 OFF, 2 ON, 1 OFF, ... */
void cpdf_setdash(char *dashspec)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%s d\n", dashspec);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%s d\n", dashspec);
}

void cpdf_nodash(void)
{
	cpdf_setdash("[] 0");
}

void cpdf_setstrokeadjust(int flag)
{
/* static char *truefalse[] = {"false", "true", ""}; */
    if(pdfLevelMaj >= 1 && pdfLevelMin >= 2) {
	/* This does not appear to be implemented yet in Adobe Acrobat Reader 3.01 (1998-07-19) */
/*
	if(useContentMemStream) {
	    sprintf(spbuf, "%s SA\n", truefalse[flag&1]);
	    cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
	}
	else
	    fprintf(fpcontent, "%s SA\n", truefalse[flag&1]);
*/
    }
}

void cpdf_concat(float a, float b, float c, float d, float e, float f)
{
    cpdf_rawConcat(a, b, c, d, x_Domain2Points(e), y_Domain2Points(f));
}


/* concatenate CTM (coordinate transformation matrix) */
void cpdf_rawConcat(float a, float b, float c, float d, float e, float f)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.4f %.4f %.4f %.4f %.4f %.4f cm\n", a, b, c, d, e, f);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.4f %.4f %.4f %.4f %.4f %.4f cm\n", a, b, c, d, e, f);
}

void cpdf_rotate(float angle)
{
float vsin, vcos;
    angle *= PI/180.0;
    vsin = sin(angle);
    vcos = cos(angle);
    cpdf_rawConcat(vcos, vsin, -vsin, vcos, 0.0, 0.0);
}

void cpdf_translate(float xt, float yt)
{
    cpdf_rawTranslate(x_Domain2Points(xt), y_Domain2Points(yt));
}

void cpdf_rawTranslate(float xt, float yt)
{
    cpdf_rawConcat(1.0, 0.0, 0.0, 1.0, xt, yt);
}

void cpdf_scale(float sx, float sy)
{
    cpdf_rawConcat(sx, 0.0, 0.0, sy, 0.0, 0.0);
}

void cpdf_setflat(int flatness)		/* flatness = 0 .. 100 */
{
    if(useContentMemStream) {
	sprintf(spbuf, "%d i\n", flatness);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%d i\n", flatness);
}

void cpdf_setlinejoin(int linejoin)	/* linejoin = 0(miter), 1(round), 2(bevel) */
{
    if(useContentMemStream) {
	sprintf(spbuf, "%d j\n", linejoin);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%d j\n", linejoin);
}

void cpdf_setlinecap(int linecap)	/* linecap = 0(butt end), 1(round), 2(projecting square) */
{
    if(useContentMemStream) {
	sprintf(spbuf, "%d J\n", linecap);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%d J\n", linecap);
}

void cpdf_setmiterlimit(float miterlimit)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.4f M\n", miterlimit);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.4f M\n", miterlimit);
}

void cpdf_setlinewidth(float width)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.4f w\n", width);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.4f w\n", width);
}


