/* cpdfRawPlot.c  -- plotting functions in raw domain of points
 * Copyright (C) 1998 FastIO Systems, All Rights Reserved.
 * For conditions of use, license, and distribution, see LICENSE.txt or LICENSE.pdf.

	Note: Better circle and arc (raw and domain) plot functions are in cpdfArc.c

*/

#include "version.h"

#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "cpdflib.h"		/* This must be included before all other local include files */
#include "cglobals.h"

/* raw domain plot functions */
float xcurr = 0.0, ycurr = 0.0;


void cpdf_rawMoveto(float x, float y)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.3f %.3f m\n", x, y);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.3f %.3f m\n", x, y);
    xcurr = x; ycurr = y;
}

void cpdf_rawRmoveto(float x, float y)
{
    xcurr += x; ycurr += y;
    if(useContentMemStream) {
	sprintf(spbuf, "%.3f %.3f m\n", xcurr, ycurr);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.3f %.3f m\n", xcurr, ycurr);
}


void cpdf_rawLineto(float x, float y)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.3f %.3f l\n", x, y);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.3f %.3f l\n", x, y);
    xcurr = x; ycurr = y;
}

void cpdf_rawRlineto(float x, float y)
{
    xcurr += x; ycurr += y;
    if(useContentMemStream) {
	sprintf(spbuf, "%.3f %.3f l\n", xcurr, ycurr);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.3f %.3f l\n", xcurr, ycurr);
}


void cpdf_rawCurveto(float x1, float y1, float x2, float y2, float x3, float y3)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.3f %.3f %.3f %.3f %.3f %.3f c\n", x1, y1, x2, y2, x3, y3);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.3f %.3f %.3f %.3f %.3f %.3f c\n", x1, y1, x2, y2, x3, y3);
    xcurr = x3; ycurr = y3;
}

/* This is used only for circle marker in cpdfMark.c */
void cpdf_rawQuickCircle(float xc, float yc, float r)
{
float b = 1.3333333;
	cpdf_rawMoveto(xc-r, yc);
	cpdf_rawCurveto(xc-r, yc+b*r, xc+r, yc+b*r, xc+r, yc);
	cpdf_rawCurveto(xc+r, yc-b*r, xc-r, yc-b*r, xc-r, yc);
	cpdf_closepath();
	xcurr = xc; ycurr = yc;
}

void cpdf_rawRect(float x, float y, float w, float h)
{
    if(useContentMemStream) {
	sprintf(spbuf, "%.3f %.3f %.3f %.3f re\n", x, y, w, h);
	cpdf_writeMemoryStream(currentMemStream, spbuf, strlen(spbuf));
    }
    else
	fprintf(fpcontent, "%.3f %.3f %.3f %.3f re\n", x, y, w, h);
    xcurr = x; ycurr = y;
}

void cpdf_closepath(void)
{
    if(useContentMemStream)
	cpdf_memPuts("h\n", currentMemStream);
    else
	fprintf(fpcontent, "h\n");
}

void cpdf_stroke(void)
{
    if(useContentMemStream)
	cpdf_memPuts("S\n", currentMemStream);
    else
	fprintf(fpcontent, "S\n");
}

void cpdf_fill(void)
{
    if(useContentMemStream)
	cpdf_memPuts("f\n", currentMemStream);
    else
	fprintf(fpcontent, "f\n");
}

void cpdf_eofill(void)
{
    if(useContentMemStream)
	cpdf_memPuts("f*\n", currentMemStream);
    else
	fprintf(fpcontent, "f*\n");
}

void cpdf_fillAndStroke(void)
{
    if(useContentMemStream)
	cpdf_memPuts("B\n", currentMemStream);
    else
	fprintf(fpcontent, "B\n");
}

void cpdf_eofillAndStroke(void)
{
    if(useContentMemStream)
	cpdf_memPuts("B*\n", currentMemStream);
    else
	fprintf(fpcontent, "B*\n");
}

void cpdf_clip(void)
{
    if(useContentMemStream)
	cpdf_memPuts("W\n", currentMemStream);
    else
	fprintf(fpcontent, "W\n");
}

void cpdf_eoclip(void)
{
    if(useContentMemStream)
	cpdf_memPuts("W*\n", currentMemStream);
    else
	fprintf(fpcontent, "W*\n");
}

void cpdf_newpath(void)
{
    if(useContentMemStream)
	cpdf_memPuts("n\n", currentMemStream);
    else
	fprintf(fpcontent, "n\n");
}


