/*
  MiscArrowButtonCell.h
  INHERITS FROM: 	ButtonCell
  AUTHOR:			Todd Thomas, Copyright 1994, 1995, 1996 by Todd Thomas
  START DATE:		Jan 16, 1993
  LAST CHANGED:		August 4, 1996
  VERSION 			3.0
  CHANGES:			See the end of the implementation file.
  
  With the help of ArrowButton, this is a recreation of the 
  button (well, it was a View there) from Websters.app (in the 
  Preferences panel). 
  
  I created a new designated initializer, since it would be nice
  to be able to set both sides of the button at once. Also, since
  stringValue did not return anything useful, I made it return
  whichever of the titles is currently selected.
  
  This object is included in the MiscKit by permission from the author
  and its use is governed by the MiscKit license, found in the file
  "LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
  for a list of all applicable permissions and restrictions.
*/
 
#import <AppKit/NSButtonCell.h>
#import <Foundation/NSGeometry.h>

// Use the method setArrowAlignment: with these defines
typedef enum {	
    MiscArrowAlignmentAbsolute = 0,
    MiscArrowAlignmentRelative = 1
} MiscArrowAlignment;

// Forward class declarations
@class NSString;
@class NSView;
@class NSCoder;


@interface MiscArrowButtonCell : NSButtonCell
{
    float cellHeight;		/*" We need to keep our cell height handy "*/
    unsigned int arrowAlignment;	/*" Relative or absolute alignment? "*/
}

/*" Class initialization "*/
+ (void) initialize;

/*" Initialization "*/
- (id) init;
- (id) initTextCell:(NSString*)aString;
- (id) initTextCell:(NSString*)aString alternateTitle:(NSString*)altString;

/*" Our state "*/
- (NSString*) stringValue;
- (MiscArrowAlignment) arrowAlignment;
- (void) setArrowAlignment: (MiscArrowAlignment)alignment;

/*" Our size "*/
- (NSSize) cellSizeForBounds:(NSRect)theRect;
- (NSRect) titleRectForBounds:(NSRect)theRect;
- (NSRect) alternateTitleRectForBounds:(NSRect)theRect;

/*" Displaying "*/
- (void) drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView*)controlView;
- (void) drawWithFrame:(NSRect)cellFrame inView:(NSView*)controlView;

/*" Archiving "*/
- (id) initWithCoder:(NSCoder*)aDecoder;
- (void) encodeWithCoder:(NSCoder*)aCoder;

@end

