
/*
   MiscFileDragCell.h
   Author:	Todd Thomas <tthomas@thoughtport.com>
   Created:	July 14, 1996

   $Id: MiscFileDragCell.h,v 1.3 1996/10/07 02:49:19 todd Exp $

   This object is included in the MiscKit by permission from the author
   and its use is governed by the MiscKit license, found in the file
   "LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
   for a list of all applicable permissions and restrictions.

    Copyright (C) 1996 Todd Thomas
    Use is governed by the MiscKit license
*/

#import <AppKit/NSDragging.h>
//#import <MiscAppKit/MiscDragCell.h>
#import "MiscDragCell.h"


@interface MiscFileDragCell : MiscDragCell
{
    NSArray* _filenames;			/*" The filename(s) we currently represent. "*/
    BOOL _allowDoubleClickLaunch; 	/*" Double click asks workspace to launch us? "*/
}

/*" Class iniatialization "*/
+ (void) initialize;

/*" Temp title "*/
+ (NSString*) tempTitleToDisplay;
+ (void) setTempTitleToDisplay:(NSString*)newTempTitle;

/*" Initializatin/deallocation "*/
- (id) init;
- (void) dealloc;

/*" Copying "*/
- (id) copyWithZone:(NSZone*)zone;

/*" Acceptable types "*/
- (NSArray*) acceptingPasteboardTypes;

/*" Our contents "*/
- (NSString*) filename;
- (void) setFilename:(NSString*)aFilename;
- (NSArray*) filenames;
- (void) setFilenames:(NSArray*)filenames;

/*" Options "*/
- (void) setAllowsDoubleClickLaunch:(BOOL)aBool;
- (BOOL) allowsDoubleClickLaunch;

- (void) launch:sender;

/*" Source dragging "*/
- (BOOL) trackMouse:(NSEvent*)theEvent inRect:(NSRect)cellFrame
            ofView:(NSView*)controlView untilMouseUp:(BOOL)flag;
- (BOOL) prepareForSourceDrag;

/*" Display options "*/
- (NSString*) titleToDisplay;
- (void) prepareTextCellForDisplay;

/*" Our title "*/
- (NSString*) titleForFilenames:(NSArray*)filenames;

/*" Archiving "*/
- (id) initWithCoder:(NSCoder*)aDecoder;
- (void) encodeWithCoder:(NSCoder*)aCoder;

@end


@interface MiscFileDragCell (NSDraggingDestination)

- (unsigned int) draggingEntered:(id <NSDraggingInfo>)sender;
- (BOOL) performDragOperation:(id <NSDraggingInfo>)sender;
- (void) concludeDragOperation:(id <NSDraggingInfo>)sender;

@end

