/*	MiscNodeStyle.h

	Copyright 1996 Uwe Hoffmann.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 2 (August 1996)
*/

#import <AppKit/NSColor.h>
#import <Foundation/NSObject.h>

/*"The MiscEndingType defines the line ending for lines connecting nodes"*/
typedef enum {
        MiscNoEnding,
        MiscArrowEnding,
        MiscHollowEnding,
        MiscDoubleEnding,
        MiscSolidEnding,
        MiscCircleEnding
} MiscEndingType;

/*"The MiscTextPlacement defines the text placement in a node"*/
typedef enum {
    	MiscTopTextPlacement,
    	MiscMiddleTextPlacement,
    	MiscBottomTextPlacement
} MiscTextPlacement;    


@interface MiscNodeStyle:NSObject <NSCopying, NSCoding>
{
 @private
	NSColor *fillColor, *outlineColor;
	BOOL fill, outline;
	float linewidth;
	BOOL automaticResize;
        MiscEndingType childEnding,parentEnding;
        MiscTextPlacement textPlacement;
}

- (BOOL)isEqual:(id)anObject;

/*"Setting and accessing attributes"*/
- (NSColor *)fillColor;
- (void)setFillColor:(NSColor *)aColor;
- (NSColor *)outlineColor;
- (void)setOutlineColor:(NSColor *)aColor;
- (BOOL)fill;
- (void)setFill:(BOOL)aBOOL;
- (BOOL)outline;
- (void)setOutline:(BOOL)aBOOL;
- (float)linewidth;
- (void)setLinewidth:(float)aLinewidth;
- (BOOL)automaticResize;
- (void)setAutomaticResize:(BOOL)aBOOL;
- (MiscTextPlacement)textPlacement;
- (void)setTextPlacement:(MiscTextPlacement)aTextPlacement;
- (MiscEndingType)childEnding;
- (void)setChildEnding:(MiscEndingType)anEnding;
- (MiscEndingType)parentEnding;
- (void)setParentEnding:(MiscEndingType)anEnding;

@end

