/* MiscSwapView_ByObject				 
 *
 * This is a MiscSwapView category. I can handle swapping of different 
 * contentViews (controlled by MiscSwapViewItem's) into ourself by
 * comparing identifier objects.
 *
 * Usage: To work properly every selectedSwapViewItem has to register itself
 *		  at the corresponding swapView. The object identifiering the swap
 *		  should invoke the sV-object and this one has to decide which 
 *   	  selectedSwapViewItem has to come to front.
 *		  The identifier instance stores the identifiering object to have it at
 *		  hand when a findController(..) needs it to make the decision.
 *
 *		  For the first time the swapView will be uninitialized! The app
 *		  has to identifier some kind of default swap maybe by a 
 *		  [swapView swapAction:defaultObject];
 *
 * Notes: To implement a different controller-finding behavior you should only
 *		  override the findControllerByTag/object methods. They should return
 *		  the selectedSwapViewItem to use next ... or nil.
 *		  Sometimes swapAction can provide a identifier adjustment too. As done
 *		  with the ..ByMatrix class.
 *
 * Written by: 		Thomas Engel
 * Created:    		24.01.1994 (Copyleft)
 * Last modified: 	08.03.1994
 */

extern NSString * MiscSwapViewItemWillGetSelectedNotification;
extern NSString * MiscSwapViewItemDidGetSelectedNotification;
extern NSString * MiscSwapViewItemWillGetDeselectedNotification;
extern NSString * MiscSwapViewItemDidGetDeselectedNotification;


@interface MiscSwapView (ByObject)

// swapContentView is invoked by the action-buttons.
// And if somebody wants to know who identifiered the swap..[identifier]

- (void)swapContentView:(id)sender;
- (void)selectSwapViewItem:(MiscSwapViewItem *)anItem;
- (void)selectSwapViewItemWithIdentifier:(id)anObject;
- (MiscSwapViewItem *)selectedSwapViewItem;

// Here are some methods that allow some selectedSwapViewItem handling.
// There should be no need to change the list by hand!

- (void)addSwapViewItem:(id)anItem;
- (void)insertSwapViewItem:(id)anItem atIndex:(int)index;
- (void)removeSwapViewItem:(id)anItem;
- (void)removeAllSwapViewItems;
- (NSArray *)swapViewItems;

- (void)_registerNotificationObserver:(id)anObject;
- (void)_unregisterNotificationObserver:(id)anObject;

- (void)setTagComparison:(BOOL)flag;
- (BOOL)doesTagComparison;

// These are the methods that decides which controller to show activate next.
// Here is the place to add some custom behavior. The methods byTag/object
// should work with no pain in any subclass too. For details see the popup and
// ByMatrix subclasses of MiscSwapView.
// Sometime you just have to make some minor fixes inside findController.
 
- (id)swapViewItemWithIdentifier:(id)anObject;
- (id)swapViewItemWithIdentifier:(id)anObject comparingTags:(BOOL)flag;

@end

// This method might be implemented by the delegate and is only useful it we really
// swap by identifiers..and not just by putting in a new view.
// SwapItems also receive these notifications by default and the current item will
// also obtain the right to intercept a "swap" by implementing the swapView:should... method.
//
// Time will tell if we should switch to a combined notification
// which provides information about the new and the old item in the notifications
// user info.
// then we could just have a:
//
// - (void)swapViewItemWillChange:(NSNotification *)notification;
// - (void)swapViewItemDidChange:(NSNotification *)notification;
//
// Lets see how the current solution scales...

@interface NSObject (MiscSwapViewItemNotification)

- (BOOL)swapView:(MiscSwapView *)swapView shouldSelectSwapViewItem:(MiscSwapViewItem *)swapViewItem;
- (void)swapViewItemWillGetSelected:(NSNotification *)notification;
- (void)swapViewItemDidGetSelected:(NSNotification *)notification;
- (void)swapViewItemWillGetDeselected:(NSNotification *)notification;
- (void)swapViewItemDidGetDelected:(NSNotification *)notification;

// Note do we need notifications for the regular view swapping ??

@end


/*
 * History: 08.03.94 Changed the findMethods to make them nicer for other
 *					 actions.
 *
 *			14.02.94 Some minor changes to make it a swapView category.
 *
 *			24.01.94 Made it a subclass of MiscSwapView
 *
 *			08.01.94 Switched to tagComparison for better reading.
 *					 choosesByTagFirst was not that nice.
 *
 *			21.12.93 Derived from my old swapPopManager this is a simple usable
 *					 and subcallable object.
 *					 Some viewController handling methods added.
 *
 *			04.12.93 Added the delegates methods.
 *
 *  		04.11.93 First methods hacked together.
 *
 *
 * Bugs: - not really
 *
 *		 - swapContentView. Ok. I could have stay with Greg's swapAction but I
 *		   don't find it a good method name. If you like it - creat your own 
 *		   compatibility category.
 */
