/*=============================== MiscCoord.h ===============================*/
/* MiscCoord is an abstract super class which contains and supports double
   precision floating point values representing locations in a three
   dimensional coordinate system.

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see
		the MiscKit license.

HISTORY
22-Feb-93  Dale Amon at GPL
	   Created.
*/

#import <Foundation/NSObject.h>
#import <MiscFoundation/MiscCoordConverterClient.h>
#import <MiscFoundation/MiscCoordConverterServer.h>

@class Storage;

#define	MISC_COORD_VERSION_ID	0.8

#define MISC_DIMENSIONS		3		/* 3d coordinates */
#define MISC_ELEMENT_DESCRIPTION	"[3d]"		/* description of one point */
#define MISC_DEFAULT_POINT_CAPACITY	1

/* Define some constants with 21 significant digits starting from 21
   digits of Pi
*/
#import <math.h>
#define	MISC_RADIANS_PER_DEGREE	(M_PI/180.0)
#define	MISC_DEGREES_PER_RADIAN	(180.0/M_PI)

/* round off at 15 digit after decimal point. This cures some problems with
   going back and forth between radians and degrees */

#define MISC_ROUND_OFF	.000000000000005

@interface MiscCoord:NSObject <MiscCoordConverterClient, NSCoding>
{
	NSString  *description;
	unsigned int  curIndex, curBlockSize;
	id  constants;
	id <MiscCoordConverterServer>  converter;
	Storage  *pntStorage;
}

+ (void)initialize;

- initDescription: (NSString *) txt
       converter: (id <MiscCoordConverterServer>) aConverter
       constants: anObject;
- init;
- (void)dealloc;

- (BOOL) convert:      (id <MiscCoordConverterClient>) aCoord;
- (BOOL) convertCoord: (id <MiscCoordConverterClient>) aCoord;

- (id <MiscCoordConverterServer>) converter;
- (NSString *)	      description;
- 			      setDescription: (NSString *) txt;

- (BOOL) selectExistingPoints:  (unsigned int) n blockSize: (unsigned int) m; 
- (BOOL) selectAndSetNumPoints: (unsigned int) n blockSize: (unsigned int) m; 
- (BOOL) selectAndSetMinPoints: (unsigned int) n blockSize: (unsigned int) m;

- (unsigned int) numPoints;
- (unsigned int) curIndex;

- 		setCoord:(double)  c1 : (double)  c2 : (double)  c3;
- 		coord:   (double*) c1 : (double*) c2 : (double*) c3;
- (double)	coord1;
- (double)	coord2;
- (double)	coord3;

@end

