/*========================= MiscCoordConverter.h ============================*/
/* MiscCoordConverter class supports the writing of converters between
   coordinate systems. All values are double precision floating point
   numbers representing locations in a three dimensional coordinate system.

   MiscCoordConverters are not archived because they contain only data that is
   recoverable or is temporary.

   The methods in this class are only for use by its subclasses and should not
   be sent by a non-subclass. If they are, your program will most likely
   crash immediately...IF you are lucky...

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see
		the MiscKit license.

HISTORY
10-Mar-93  Dale Amon at GPL
	   Created.
*/

#import <Foundation/Foundation.h>
#import <MiscFoundation/MiscCoordConverterServer.h>

#define	MISC_COORD_CONVERTER_VERSION_ID	0.8

#define MISC_SERVICE_SIZE		(sizeof(struct __MiscService))
#define MISC_SERVICE_DESCRIPTION	"{##:}"

@interface MiscCoordConverter : NSObject <MiscCoordConverterServer, NSCoding>
{	id		services; /* pair list of what we know how to xlate. */
	/* Description of current job */
	SEL		theTransform;		/* conversion method */
	id		aSubcontractor;		/* and who can do the work */
	id		srcConstants,		/* special instructions */
			dstConstants;

	unsigned int	dimensions;		/* dimensions of points */
	double		*src,*dst;		/* data pointers */
	unsigned int	npoints;		/* # points to xlate */
	BOOL		sameConstants;		/* set YES if constants are the same */
}

+ (void)initialize;

- init;
- (void)dealloc;

- addService: (SEL) aSelector convertsFrom: (Class) one to: (Class) two;
- (SEL) fastCopySelector;

@end
