/* MiscMutableData.h created by giddings on Tue 04-Feb-1997 */

//Written By Michael Giddings, 1996 and 1997
//giddings@barbarian.com
//giddings@whitewater.chem.wisc.edu

//More notes are in the .m file


#import <Foundation/Foundation.h>

#define MISC_BIGENDIAN	0
#define MISC_LITTLEENDIAN	1


@interface MiscMutableData : NSObject <NSCoding>
{
    unsigned char byteOrder;
    unsigned char type;
    NSMutableData *data;
}

+ (MiscMutableData *)data;
+ (MiscMutableData *)dataWithCapacity:(unsigned int)aNumItems;
+ (MiscMutableData *)dataWithLength:(unsigned int)length;
+ (MiscMutableData *)dataWithBytes:(const void *)bytes length:(unsigned int)length;
+ (MiscMutableData *)dataWithBytesNoCopy:(void *)bytes length:(unsigned int)length;
+ (MiscMutableData *)dataWithContentsOfFile:(NSString *)path;
+ (MiscMutableData *)dataWithContentsOfMappedFile:(NSString *)path;
+ (MiscMutableData *)dataWithData:(NSMutableData *)aData;

- (MiscMutableData *)initWithCapacity:(unsigned int)capacity;
- (MiscMutableData *)initWithLength:(unsigned int)length;

- (id)init;
- (id)initWithBytes:(const void *)bytes length:(unsigned int)length;
- (id)initWithBytesNoCopy:(void *)bytes length:(unsigned int)length;
- (id)initWithContentsOfFile:(NSString *)path;
- (id)initWithContentsOfMappedFile:(NSString *)path;
- (MiscMutableData *)initWithData:(NSMutableData *)thedata;

- (id)copyWithZone:(NSZone *)zone;
- (id)mutableCopyWithZone:(NSZone *)zone;

- (MiscMutableData *)setType:(unsigned char)thetype;
- (unsigned char)type;
- (unsigned char)hostOrder;
- (void)setByteOrder:(unsigned char)order;
- (unsigned char)byteOrder;

//Methods reimplemented from NSMutableData due to static typing requirements
- (unsigned int)length;
- (const void *)bytes;
- (void *)mutableBytes;
- (void)setLength:(unsigned int)length;

- (void)dealloc;

//For forwarding to embedded NSData
- (void)forwardInvocation:(NSInvocation *)anInvocation;


- (void)swapDoubleToHost;
- (void)swapFloatToHost;
- (void)swapLongToHost;
- (void)swapIntToHost;
- (void)swapShortToHost;
- (void)swapToHost;


@end
