/*	MiscStack.h

	Copyright 1995 Christopher J. Kane.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 1 (1 February 1995)
*/

#import <Foundation/NSObject.h>

@interface MiscStack : NSObject <NSCopying, NSCoding>

- (id)init;					// designated initializer

- (BOOL)isEmpty;
- (id)pop;
- (void)pushObject:(id)anObject;

@end

@class NSArray, NSDictionary;

@interface MiscStack (MiscStackExtensions)

+ (MiscStack *)stack;
+ (MiscStack *)stackWithArray:(NSArray *)anArray;
+ (MiscStack *)stackWithObjects:(id *)objects count:(unsigned int)count;
+ (MiscStack *)stackWithObjects:(id)firstObj, ...;
+ (MiscStack *)stackWithReversedArray:(NSArray *)anArray;

- (id)initWithEnumerator:(NSEnumerator *)enumerator;
- (id)initWithObjects:(id *)objects count:(unsigned int)count;
- (id)initWithObjects:(id)firstObj, ...;

- (NSArray *)multipop:(unsigned int)number;
- (id)npop:(unsigned int)number;
- (void)popAllObjects;

- (id)top;
- (unsigned int)count;

- (void)pushStack:(MiscStack *)aStack;
- (void)pushWithEnumerator:(NSEnumerator *)enumerator;

- (BOOL)isEqualToStack:(MiscStack *)otherStack;

- (NSString *)description;
- (NSString *)descriptionWithLocale:(NSDictionary *)aLocale;

@end
