/*	MiscTree.h

	Copyright 1995 Christopher J. Kane.

	This notice may not be removed from this source code.
	The use and distribution of this software is governed by the
	terms of the MiscKit license agreement.  Refer to the license
	document included with the MiscKit distribution for the terms.

	Version 1 (1 February 1995)
*/

#import <Foundation/NSObject.h>

@interface MiscTree : NSObject <NSCopying, NSCoding>

- (id)init;					// designated initializer

- (id)userInfo;
- (void)setUserInfo:(id)anObjectOrNil;

- (MiscTree *)parentTree;
- (void)setParentTree:(MiscTree *)aTreeOrNil;

- (void)addSubtree:(MiscTree *)aTree;
- (BOOL)isSubtree:(MiscTree *)aTree;
- (void)removeSubtree:(MiscTree *)aTree;
- (unsigned int)subtreeCount;
- (NSEnumerator *)subtreeEnumerator;

@end

@class NSArray, NSDictionary;

@interface MiscTree (MiscTreeExtensions)

+ (MiscTree *)tree;
+ (MiscTree *)treeWithSubtreesFromArray:(NSArray *)anArray;
+ (MiscTree *)treeWithSubtrees:(MiscTree *)firstObj, ...;

- (id)initWithEnumerator:(NSEnumerator *)enumerator;
- (id)initWithSubtrees:(MiscTree *)firstObj, ...;

- (BOOL)isLeaf;
- (MiscTree *)rootTree;
- (unsigned int)treeDegree;
- (unsigned int)treeHeight;
- (unsigned int)treeLevel;
- (NSArray *)subtrees;

- (void)addSubtreesWithEnumerator:(NSEnumerator *)enumerator;
- (void)replaceSubtree:(MiscTree *)subtree withTree:(MiscTree *)aTree;
- (void)removeAllSubtrees;

- (void)makeSubtreesPerform:(SEL)aSelector;
- (void)makeSubtreesPerform:(SEL)aSelector withObject:(id)anObject;
- (NSEnumerator *)ancestorEnumerator;
- (NSEnumerator *)siblingEnumerator;
- (NSEnumerator *)preorderAllSubtreeEnumerator;
- (NSEnumerator *)postorderAllSubtreeEnumerator;

- (BOOL)isAnySubtree:(MiscTree *)aTree;
- (BOOL)isEqualToTree:(MiscTree *)otherTree;
- (NSComparisonResult)compare:(id)otherTree;

- (NSString *)description;
- (NSString *)descriptionWithLocale:(NSDictionary *)locale;

@end

/**************** Other Concrete MiscTrees ****************/

@interface MiscBinarySearchTree : MiscTree
{
    id _userInfo;
    MiscBinarySearchTree *_parentTree;
    MiscBinarySearchTree *_leftSubtree;
    MiscBinarySearchTree *_rightSubtree;
}

- (id)key;
- (void)setKey:(id)anObject;

- (MiscBinarySearchTree *)leftSubtree;
- (void)setLeftSubtree:(MiscBinarySearchTree *)aTreeOrNil;
- (MiscBinarySearchTree *)rightSubtree;
- (void)setRightSubtree:(MiscBinarySearchTree *)aTreeOrNil;

- (MiscBinarySearchTree *)treeWithKey:(id)aKey;
- (MiscBinarySearchTree *)treeWithMinimumKey;
- (MiscBinarySearchTree *)treeWithMaximumKey;

- (MiscBinarySearchTree *)treeSuccessor;
- (MiscBinarySearchTree *)treePredecessor;
- (NSEnumerator *)inorderAllSubtreeEnumerator;

@end
