/*=========================== MiscUTMConstants.h ============================*/
/* MiscUTMConstants class contains and supports the constants required for
   calculating a Universal Transverse Mercator grid point.

   Note that they are made public for the sake of efficient calculation.
   This also introduces a violation of Object security and should be
   handled very carefully.

   Subclassing this is a simple way to create constants objects for any Grid.
   Make sure there is only one instance in the system and protect it from 
   deletion by overriding free.

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see
		the MiscKit license.

HISTORY
22-Feb-93  Dale Amon at GPL
	   Created.
*/

#import <Foundation/Foundation.h>
#import <MiscFoundation/miscgiskit.h>

#define	MISC_CONVERGENCE_CRITERIA .0001	/* stop at .1 mm difference,
					   so we will be accurate at least
					   to 1mm */
#define	MISC_UTM_CONSTANTS_VERSION_ID	0.8

@interface MiscUTMConstants:NSObject <NSCoding>
{ /* primary constants */
	NSString* gridName;	/* name of the UTM Grid this represents */

	double	a,b;		/* Spheroid major and minor semi-axis */
	double	F0;		/* scale factor at central Meridian */

@public
/* primary constants */
	double	phi0,lambda0;	/* True Origin in World system */
	double	E0,N0;		/* True Origin in local grid coordinates
				   meters offset from False Origin */
	double convergence;	/* The criteria for convergence */

/* secondary constants that are pre-calculated from primary constants */
	double	aF0;		/* a * F0 */
	double	bF0;		/* b * F0 */
	double	eSqrd;		/* eccentricity squared */
	double	n;		
	double  M1;		/* constant 1 in M equation */
	double  M2;		/* constant 2 in M equation */
	double  M3;		/* constant 3 in M equation */
	double  M4;		/* constant 4 in M equation */

@private
	BOOL	noFree;		/* If set, this object cannot be free'd */
}

+ (void)initialize;

- initGridName:   (NSString *) name
    trueOrigin: (double) deg_latitude : (double) deg_longitude
        inGrid: (double) e0:  (double) n0
      onSphere: (double) a0:  (double) b0
      centralMeridianScaling: (double) f0;

- override_eSqrd:(double)new_eSqrd n: (double)new_n;

- setProtected;
- setUnprotected;
- (void)dealloc;

- (NSString *) gridName;
- (BOOL) isEqual: anObject;

@end
