/*=========================== MiscZoneUTMCoord.h ============================*/
/* MiscZoneUTMCoord class contains and supports values representing locations
   in any zone of the world wide Universal Transverse Mercator coordinate
   system.

   DMA Release 0.8, Copyright @1993 by Genesis Project, Ltd. All Rights
   Reserved. For further information on terms and conditions see
		the MiscKit license.

HISTORY
26-Mar-93  Dale Amon at GPL
	   Created.
*/

#import <Foundation/Foundation.h>
#import <MiscFoundation/miscgiskit.h>

#define	MISC_ZONE_COORD_VERSION_ID	0.8

@interface MiscZoneUTMCoord:MiscUTMCoord
{
	unsigned int	zoneNumber;	/* UTM zone number */
}

+ (void)initialize;

-initDescription: (NSString *) txt zone: (unsigned int) zone;

- (void)encodeWithCoder:(NSCoder *)aCoder;
- (id)initWithCoder:(NSCoder *)aDecoder;

/* blocked methods */
-initDescription: (NSString *) txt constants: anObject;

@end
