/*
 File:       CalendarView.m

 Contains:   Source code for the custom View of the "Calendar" window

 Written by: Eric Simenel

 Created:    May 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "CalendarView.h"
#import "ComicsObj.h"

@implementation CalendarView

- (id)initWithFrame:(NSRect)rect
{
    if (self = [super initWithFrame:rect])
      {
        font = [[NSFont fontWithName:@"Ohlfs" size:10] retain];
        dictionary = [[NSMutableDictionary dictionary] retain];
        [dictionary setObject:font forKey:NSFontAttributeName];
        array = [[NSMutableArray alloc] initWithCapacity:189];
        nbSelTitles = 0;
      }
    return self;
}
- (void)dealloc
{
    [array release];
    [font release];
    [dictionary release];
    [super dealloc];
}
- (void)drawRect:(NSRect)rect
{
    char strtit[] = "      OCT NOV DEC  97 FEB MAR APR MAY JUN          OCT NOV DEC  97 FEB MAR APR MAY JUN          OCT NOV DEC  97 FEB MAR APR MAY JUN\n", strlin[200], strstart[7];
    short i, j, k, n, lastEditMonth, isharr[189][9];

    // get the right array of titles
    [comicsBase sortArray:array withBrand:brand withSeries:series withKind:kind withState:2 withSort:sort];
    nbSelTitles = [array count];
    lastEditMonth = [comicsBase lastEditMonth];

    // fill the correct month names or year value in strtit based upon the model in its declaration above
    for(i=1; i<=3; i++) for(j=1; j<=9; j++)
        strncpy(&strtit[6 + (i-1)*45 + (j-1)*4], (k = (lastEditMonth-1-9+j) % 12)?gmonths[k]:gnums[(lastEditMonth-1-9+j) / 12], 3);
    // and draw it
    [[NSString stringWithCString:strtit] drawAtPoint:NSMakePoint(0,rect.size.height-20) withAttributes:dictionary];

    // clear and fill the local array of issue numbers to be displayed
    for(i=0; i<189; i++) for(j=0; j<9; j++) isharr[i][j] = -1;
    for(i=0; i<nbSelTitles; i++)
      {
        CTitle *thisTitle = [array objectAtIndex:i];
        CIssue *thisIssue;
        short nbish = [thisTitle nbIssues];
        for(j=nbish-1; (j >= 0) && (k = [(thisIssue = [[thisTitle issues] objectAtIndex:j]) editMonth]) > (lastEditMonth-9); j--)
            if (!([thisIssue issueFlags] & mskMiss)) isharr[i][k-lastEditMonth+8] = [thisIssue issueNumber];
            else isharr[i][k-lastEditMonth+8] = -2;
        for(k=j, n=-1; (k >= 0) && (n == -1); j--)
            if (!([(thisIssue = [[thisTitle issues] objectAtIndex:k]) issueFlags] & mskMiss)) n = [thisIssue issueNumber];
        for(j=8; (j >= 0) && (isharr[i][j] == -1); j--);
        for(k=0; k<j; k++) if (isharr[i][k] != -1) n = isharr[i][k]; else isharr[i][k] = n;
      }
    // and display it
    for(i=0; i<63; i++)
      {
        strcpy(strlin, "");
        for(j=i; j < nbSelTitles; j += 63)
          {
            strcpy(strstart, [[[array objectAtIndex:j] abb] cString]);
            while (strlen(strstart) < 6) strcat(strstart, " ");
            strcat(strlin, strstart);
            for(k=0; k<9; k++)
                strcat(strcat(strlin, ((n = isharr[j][k]) < 0)?"   ":(char *)gnums[n]), " ");
            strcat(strlin, "   ");
          }
        [[NSString stringWithCString:strlin] drawAtPoint:NSMakePoint(0,rect.size.height-11*(i+3)) withAttributes:dictionary];
      }
}

- (short)nbSelTitles { return nbSelTitles; }
- (void)setKind:(short)value { kind = value; }
- (void)setSort:(short)value { sort = value; }
- (void)setBrand:(short)value { brand = value; }
- (void)setSeries:(short)value { series = value; }

@end
