#import <AppKit/AppKit.h>

/*
 File:       InputController.h

 Contains:   Header file for the Controller of the "Input" window, see also PopupInTable.h

 Written by: Eric Simenel

 Created:    May 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

@interface InputController : NSObject
{
    id inputView;
    id nbIssues;
    id nbSelTitles;
    id nbTitles;
    id curBuyMonth;
    id curEditMonth;
    id selBuyMonth;
    id selEditMonth;

    id puit;
    
    NSMutableArray *array;
    short *curIshArray;
    short nbRows;

    short brand;
    short kind;
    short series;
    short state;
    short sort;
    
    short theBuyMonth;
    short theEditMonth;

    NSScroller *myVerticalScroller;
    id saveVerticalScrollerTarget;
    SEL saveVerticalScrollerAction;

    NSColor* arrCol[6];
    NSFont *fontProp, *fontNonProp;
}

- (id)init;
- (void)awakeFromNib;

- (void)brandSelect:(id)sender;
- (void)kindSelect:(id)sender;
- (void)seriesSelect:(id)sender;
- (void)sortSelect:(id)sender;
- (void)stateSelect:(id)sender;

- (void)addNewTitle:(id)sender;
- (void)deleteThisTitle:(id)sender;
- (void)selectEditMonth:(id)sender;
- (void)selectBuyMonth:(id)sender;

- (NSMutableArray *)array;
- (id)inputView;
- (short *)curIshArray;
- (short)theBuyMonth;
- (short)theEditMonth;
- (void)setTheBuyMonth:(short)b;
- (void)setTheEditMonth:(short)e;
- (NSFont *)fontProp;
- (NSFont *)fontNonProp;

- (void)selChanged;
- (void)contentChanged;
- (BOOL)windowShouldClose:(id)sender;

// NSTableDataSource interface
- (int)numberOfRowsInTableView:(NSTableView *)tableView;
- (id)tableView:(NSTableView *)tv objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row;
- (void)tableView:(NSTableView *)tv setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row;
- (void)tableView:(NSTableView *)aTableView willDisplayCell:(id)aCell forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;

// popup button management
- (void)doClick:(id)sender;
- (void)userHasScrolled:(id)sender;

@end
