/*
 File:       VerifyController.m

 Contains:   Source code for the Controller of the "Verify" window

 Written by: Eric Simenel

 Created:    May 1997

 Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

 Change History (most recent first):

 You may incorporate this sample code into your applications without
 restriction, though the sample code has been provided "AS IS" and the
 responsibility for its operation is 100% yours.  However, what you are
 not permitted to do is to redistribute the source as "DSC Sample Code"
 after having made changes. If you're going to re-distribute the source,
 we require that you make it clear in the source that the code was
 descended from Apple Sample Code, but that you've made changes.
*/

#import "VerifyController.h"
#import "BrowserController.h"
#import "CalendarController.h"
#import "TitleLongevityController.h"
#import "OutlineController.h"
#import "ComicsObj.h"

@implementation VerifyController

// private helper method: update the UI when the data array has changed
- (void)_update
{
    [verifyView noteNumberOfRowsChanged];
    [verifyView reloadData];
}

- (void)selChanged
{
    // get the right array of titles
    [comicsBase sortArray:array withBrand:brand withSeries:series withKind:kind withState:state withSort:sort];
    nbRows = [array count];
    [nbSelTitles setIntValue:nbRows];
    [self _update];
}

- (void)brandSelect:(id)sender
{
    short newBrand = [sender indexOfSelectedItem];
    if (newBrand != brand) { brand = newBrand; [self selChanged]; }
}
- (void)kindSelect:(id)sender
{
    short newKind = [sender indexOfSelectedItem];
    if (newKind != kind) { kind = newKind; [self selChanged]; }
}
- (void)seriesSelect:(id)sender
{
    short newSeries = [sender indexOfSelectedItem];
    if (newSeries != series) { series = newSeries; [self selChanged]; }
}
- (void)stateSelect:(id)sender
{
    short newState = [sender indexOfSelectedItem];
    if (newState != state) { state = newState; [self selChanged]; }
}
- (void)sortSelect:(id)sender
{
    short newSort = [sender indexOfSelectedItem];
    if (newSort != sort) { sort = newSort; [self selChanged]; }
}

- (id)init
{
    if (self = [super init])
      {
        nbRows = 0;
        brand = 0;
        series = 0;
        kind = 0;
        state = 0;
        sort = 0;
        // I have a lttle less than 1500 titles currently, hence the following capacity...
        array = [[NSMutableArray alloc] initWithCapacity:1500];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(comicsChanged:) name:ComicsDidChangeNotification object:nil];
      }
    return self;
}
- (void)comicsChanged:(NSNotification *)note
{
    [nbIssues setIntValue:[comicsBase nbIssues]];
    [nbTitles setIntValue:[comicsBase nbTitles]];
    [self selChanged];
}
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:ComicsDidChangeNotification object:nil];
    [array release];
    [super dealloc];
}
- (void)awakeFromNib
{
    [self comicsChanged:nil];
}

// Since numberOfRowsInTableView is called a ZILLION times by the NSTableView object methods,
// do the number of rows calculation in selChanged, and save off the value in the nbRows field
// so that I can just return the value.
- (int)numberOfRowsInTableView:(NSTableView *)tableView
{
    return nbRows;
}

- (id)tableView:(NSTableView *)tv objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row
{
    CTitle *thisTitle = [array objectAtIndex:row];
    NSString *identifier = [tableColumn identifier];

    if ([identifier isEqualToString:@"Abb"])
        return [thisTitle abb];
    else if ([identifier isEqualToString:@"Title"])
        return [thisTitle title];
    else return [thisTitle listIssues];
}

// loading subprojects
- (void)newBrowser:(id)sender { [[BrowserController alloc] init]; }
- (void)newCalendar:(id)sender { [[CalendarController alloc] init]; }
- (void)newTitleLongevity:(id)sender { [[TitleLongevityController alloc] init]; }
- (void)newOutline:(id)sender { [[OutlineController alloc] init]; }

// NSApp delegate: ask the InputController if the comics database has been modified or not,
// and if the user has then saved it or not or cancelled the quit process.
- (BOOL)applicationShouldTerminate:(id)sender
{
    return [inputWindow windowShouldClose:nil]?YES:NO;
}

@end
