/*
 * Copyright 1998 by Kenneth C. Dyke
 *       All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appears in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT,
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

// This is only here because the syntax color highlighting in PB gets confused the
// first time it comes across something like this struct.
typedef union _pb_is_whacked
{
    struct
{
    unsigned long foo : 32;
} field;
unsigned long reg;
} pb_is_whacked;

typedef union
{
    struct
    {
        unsigned long l2enable : 1;
        unsigned long l2parity : 1;
        unsigned long l2size : 2;
        unsigned long l2clock : 3;
        unsigned long l2ram : 2;
        unsigned long l2dataonly : 1;
        unsigned long l2invalidate : 1;
        unsigned long l2control : 1;
        unsigned long l2writethrough : 1;
        unsigned long l2test : 1;
        unsigned long l2outputhold : 2;
        unsigned long l2slow : 1;
        unsigned long l2differential : 1;
        unsigned long l2bypass : 1;
        unsigned long l2reserved : 12;
        unsigned long l2invalidateinprogress : 1;
    } field;
    unsigned long value;
} L2CR;

typedef union
{
    struct
    {
        unsigned long pmc3select : 5;
        unsigned long pmc4select : 5;
        unsigned long reserved : 22;
    } field;
    unsigned long value;
} MMCR1;

typedef union
{
    struct
    {
        unsigned long overflow : 1;
        unsigned long counter : 31;
    } field;
    unsigned long value;
} PMC;

typedef union
{
    struct
    {
        unsigned long reserved : 23;
        unsigned long fi : 8;
        unsigned long e : 1;
    } field;
    unsigned long value;
} ICTC;

typedef union
{
    struct
    {
        unsigned long tin : 1;
        unsigned long tiv : 1;
        unsigned long threshold : 7;
        unsigned long reserved : 20;
        unsigned long tid : 1;
        unsigned long tie : 1;
        unsigned long v : 1;
    } field;
    unsigned long value;
} THRM;

typedef union
{
    struct
    {
        unsigned long reserved : 18;
        unsigned long sitv : 13;
        unsigned long e : 1;
    } field;
    unsigned long value;
} THRM3;

typedef union
{
    struct
    {
        unsigned long emcp : 1;
        unsigned long dbp : 1;
        unsigned long eba : 1;
        unsigned long ebd : 1;
        unsigned long bclk : 1;
        unsigned long reserved0 : 1;
        unsigned long eclk : 1;
        unsigned long par : 1;
        unsigned long doze : 1;
        unsigned long nap : 1;
        unsigned long sleep : 1;
        unsigned long dpm : 1;
        unsigned long reserved1: 3;
        unsigned long nhr : 1;
        unsigned long ice : 1;
        unsigned long dce : 1;
        unsigned long ilock : 1;
        unsigned long dlock : 1;
        unsigned long icfi : 1;
        unsigned long dcfi : 1;
        unsigned long spd : 1;
        unsigned long ifem : 1;
        unsigned long sge : 1;
        unsigned long dcfa : 1;
        unsigned long btic : 1;
        unsigned long reserved2: 1;
        unsigned long abe : 1;
        unsigned long bht : 1;
        unsigned long reserved3: 1;
        unsigned long noopti : 1;
    } field;
    unsigned long value;
} HID0;

typedef union
{
    struct
    {
        unsigned long reserved0 : 13;
        unsigned long pow : 1;
        unsigned long reserved1 : 1;
        unsigned long ile : 1;
        unsigned long ee : 1;
        unsigned long pr : 1;
        unsigned long fp : 1;
        unsigned long me : 1;
        unsigned long fe0 : 1;
        unsigned long se : 1;
        unsigned long be : 1;
        unsigned long fe1 : 1;
        unsigned long reserved2 : 1;
        unsigned long ip : 1;
        unsigned long ir : 1;
        unsigned long dr : 1;
        unsigned long reserved3 : 1;
        unsigned long pm : 1;
        unsigned long ri : 1;
        unsigned long le : 1;
    } field;
    unsigned long value;
} MSR;

typedef union
{
    struct
    {
        unsigned long pll : 4;
        unsigned long reserved : 28;
    } field;
    unsigned long value;
} HID1;

typedef union
{
    struct
    {
        unsigned long version : 16;
        unsigned long revision : 16;
    } field;
    unsigned long value;
} PVR;
