/*
        Copyright (c) 1999 Turbocat's Development. http://www.turbocat.de/ info@turbocat.de
*/

#import <EOAccess/EOAccess.h>

#define databaseNameKey           	@"databaseName"
#define hostNameKey    				@"hostName"

// Sun Mar 30 03:14:33 MET DST 1997 	dave@turbocat.de
// PG uses Sun Mar 30 01:26:50 1997 MET
#ifdef WIN32
#define PostgreSQLCalendarFormat @"%a %b %d %H:%M:%S %Y"
#else
#define PostgreSQLCalendarFormat @"%a %b %d %H:%M:%S %Y %Z"
#endif

@interface PostgreSQLAdaptor:EOAdaptor
{
    NSStringEncoding	_dbEncoding;
}

+ (NSDictionary *)defaultConnectionDictionary;
+ (NSDictionary*) externalTypeDict;

- initWithName:(NSString *)name;
- (Class)expressionClass;
- (EOAdaptorContext *)createAdaptorContext;
- (BOOL)isValidQualifierType:(NSString *)typeName model:(EOModel *)model;
- (void)assertConnectionDictionaryIsValid;

@end

@interface PostgreSQLAdaptor (ExternalTypeMapping)

+ (NSString *)defaultExternalType;
+ (NSDictionary *)externalToInternalTypeMap;
+ (NSString *)internalTypeForExternalType:(NSString *)extType model:(EOModel *)model;
+ (NSArray *)externalTypesWithModel:(EOModel *)model;
+ (void)assignExternalInfoForAttribute:(EOAttribute *)attribute;
+ (void)assignExternalInfoForEntity:(EOEntity *)entity;
+ (void)assignExternalInfoForEntireModel:(EOModel *)model;

@end
