/*
 * sa_rld() loads the specified object in memory against the specified
 * base file in memory.  The output is placed in memory starting at
 * the value of the parameter workmem_addr and the size of the memory
 * used for the output returned indirectly through workmem_size.
 * Initially *workmem_size is the size of the working memory.
 */
typedef int sa_rld_t(
char		   *basefile_name,  /* base file name */
struct mach_header *basefile_addr,  /* mach header of the base file */

char               *object_name,    /* name of the object to load */
char               *object_addr,    /* addr of the object in memory to load */
unsigned long       object_size,    /* size of the object in memory to load */

char               *workmem_addr,   /* address of working memory */
unsigned long      *workmem_size,   /* size of working memory (in/out) */

char               *error_buf_addr, /* address of error message buffer */
unsigned long       error_buf_size, /* size of error message buffer */

char               *malloc_addr,    /* address to use for initializing malloc */
unsigned long       malloc_len);    /* length to use for same */

#ifdef SA_RLD
extern sa_rld_t sa_rld;

/*
 * These two variables are set in sa_rld() and used in layout_segments()
 * as the place to put the output in memory.
 */
extern char         *sa_rld_output_addr;
extern unsigned long sa_rld_output_size;
#endif /* SA_RLD */


