#import "NSApp+PopupMenu.h"

@implementation NSApplication (PopupMenu)
- (void)rightMouseDown:(NSEvent *)theEvent
{
   NSPoint     evLocation;
   NSEvent     *event;
   static id   myMenuView = nil;

   if (myMenuView == nil)
   {
      myMenuView = [[NSMenuView alloc] init];
      [myMenuView setMenu: [self mainMenu]];
   }

   if ([theEvent window])
   {
      // Is this necessary?
      evLocation = [[theEvent window] convertBaseToScreen: [theEvent locationInWindow]];
   }
   else
   {
      evLocation = [theEvent locationInWindow];
   }
   
   [[myMenuView window] setFrameTopLeftPoint: evLocation];
   
   [[myMenuView window] makeKeyAndOrderFront: self];
   evLocation.x = evLocation.x - 5;
   evLocation = [[myMenuView window] convertScreenToBase: evLocation];
   event = [NSEvent mouseEventWithType: NSRightMouseDown
                              location: evLocation
                         modifierFlags: [theEvent modifierFlags]
                             timestamp: [theEvent timestamp]
                          windowNumber: [[myMenuView window] windowNumber]
                               context: [theEvent context]
                           eventNumber: [theEvent eventNumber]
                            clickCount: [theEvent clickCount]
                              pressure: [theEvent pressure]];

   [myMenuView trackWithEvent: event];
   [[myMenuView window] orderOut: self];
}
@end
