// Copyright 1998 Omni Development, Inc.  All rights reserved.

#import "OAIAnalysis.h"
#import "OAICorpus.h"
#import <AIAT/DocTextCharStream.h>
#import <AIAT/DowncaseFilter.h>
#import <AIAT/ShortWordFilter.h>
#import <AIAT/StringTerm.h>

extern "C" {
    #import <OmniBase/rcsid.h>
    #import <Foundation/Foundation.h>
    #import "OAITokenizerRegistry.h"
}

RCS_ID("$Header: /LocalDeveloper/Source/CVS/OmniGroup/OmniAIAT/OAIAnalysis.M,v 1.1 1998/02/26 01:54:01 toon Exp $")

IATokenStream *OAIAnalysis::MakeTokenStream(IADocText *text)
{
    OAIDocText *realText;
    DocTextCharStream *stream;
    IATokenStream *tokenizer;

    stream = new DocTextCharStream(text);
    realText = (OAIDocText *)text;
    tokenizer = [[OAITokenizerRegistry sharedRegistry] tokenizerForExtension:(NSString *)realText->GetExtension() withStream:stream];

    return new DowncaseFilter(new ShortWordFilter(tokenizer));
}

IATerm *OAIAnalysis::GetProtoTerm()
{
    return new StringTerm("");
}
