// Copyright 1998 Omni Development, Inc.  All rights reserved.

#import "OAICorpus.h"

extern "C" {
    #import <Foundation/Foundation.h>
    #import "OAITokenizerRegistry.h"
}

#import <OmniBase/rcsid.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAIAT/OAICorpus.M,v 1.4 1998/02/26 13:29:26 kc Exp $")

OAIDocIterator::OAIDocIterator(IADocIterator *originalIterator)
{
    original = originalIterator;
    return this;
}

OAIDocIterator::~OAIDocIterator()
{
    delete original;
}

IADoc* OAIDocIterator::GetNextDoc()
{
    UFSDirectoryDoc *doc;
    NSString *file;

    while ((doc = (UFSDirectoryDoc *)original->GetNextDoc())) {
        file = [NSString stringWithCString:(char *)(doc->GetFileName())];
        if ([file characterAtIndex:0] != '.' && [[OAITokenizerRegistry sharedRegistry] hasTokenizerForExtension:[file pathExtension]]) {
            return doc;
        }
        delete doc;
    }
    return NULL;
}

IADocIterator* OAICorpus::GetDocIterator()
{
    IADocIterator *original, *result;

    original = UFSDirectoryCorpus::GetDocIterator();
    result = new OAIDocIterator(original);
    return result;
}

IADocText *OAICorpus::GetDocText(const IADoc *doc)
{
    UFSDirectoryDoc *realDoc = (UFSDirectoryDoc *)doc;
    unsigned char *docName, *docPath, *combined;
    uint32 length;

    docName = realDoc->GetFileName();
    docPath = this->GetDirectory(realDoc->GetDirectoryID(), &length);
    // Casting unsigned char * to char * to avoid warnings about passing unsigned char * as argument to functions expecting char *
    combined = alloca(length + strlen((char *)docName)+1);
    strcpy((char *)combined, (char *)docPath);
    strcpy((char *)combined + length, (char *)docName);
    return new OAIDocText(combined);
}

OAIDocText::OAIDocText(const byte *path) : UFSDocText(path)
{
    // Casting unsigned char * to char * to avoid warnings about passing unsigned char * as argument to functions expecting char *
    extension = [[[NSString stringWithCString:(char *)path] pathExtension] retain];
}

OAIDocText::~OAIDocText()
{
    [(id)extension release];
}

void *OAIDocText::GetExtension()
{
    return extension;
}