// Copyright 1998 Omni Development, Inc.  All rights reserved.

#import "OAIObjCTokenizer.h"

extern "C" {
    #import <OmniBase/rcsid.h>
};

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAIAT/OAIObjCTokenizer.M,v 1.2 1998/02/26 13:29:26 kc Exp $")

OAIObjCTokenizer::OAIObjCTokenizer(id <OAITokenizerInstance> objCObject, OFStringScanner *aScanner)
{
    tokenizer = [objCObject retain];
    scanner = [aScanner retain];
}

OAIObjCTokenizer::~OAIObjCTokenizer()
{
    [tokenizer release];
    [scanner release];
}

IAToken *OAIObjCTokenizer::GetNextToken()
{
    NSString *string;
    uint32 start, end;

    start = scannerScanLocation(scanner);
    string = [tokenizer nextToken];
    end = scannerScanLocation(scanner);
    return new IAToken(new IATerm((const unsigned char *)[string cString], (long unsigned int)[string cStringLength]), start, end);
}

void OAIObjCTokenizer::GetTextSpan(byte *dest, uint32 startPos, uint32 endPos)
{
    unsigned int currentLocation;
    NSString *string;

    currentLocation = [scanner scanLocation];
    [scanner setScanLocation:startPos];
    string = [scanner readCharacterCount:(endPos - startPos)];
    [string getCString:(char *)dest];
    [scanner setScanLocation:currentLocation];
}

