// Copyright 1998 Omni Development, Inc.  All rights reserved.

extern "C" {
    #import "OAIObjCTokenizerHolder.h"
    #import "OAIStringScanner.h"
    #import <OmniBase/rcsid.h>
}

RCS_ID("$Header: /LocalDeveloper/Source/CVS/OmniGroup/OmniAIAT/OAIObjCTokenizerHolder.M,v 1.1 1998/02/26 01:54:09 toon Exp $")

#import "OAIObjCTokenizer.h"

@implementation OAIObjCTokenizerHolder

- (void *)cppTokenizerForStream:(void *)stream;
{
    OAIStringScanner *scanner;
    OAIObjCTokenizer *tokenizer;

    scanner = [[OAIStringScanner alloc] initWithStream:stream];
    tokenizer = new OAIObjCTokenizer([tokenizerFactory tokenizerForScanner:scanner], scanner);
    [scanner release];
    return tokenizer;
}

@end
