// Copyright 1998 Omni Development, Inc.  All rights reserved.

extern "C" {
#import "OAIQuery.h"
#import "OAIIndex.h"
}

#import <Foundation/Foundation.h>
#import <AIAT/UFSStorage.h>
#import <AIAT/InvertedIndex.h>
#import <AIAT/InvertedAccessor.h>
#import <AIAT/UFSDirectoryCorpus.h>
#import <AIAT/SimpleAnalysis.h>
#import <AIAT/IAAccessor.h>
#import <AIAT/UFSDirectoryCorpus.h>
#import <OmniBase/rcsid.h>

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAIAT/OAIQuery.M,v 1.5 1998/03/06 22:40:07 kc Exp $")

@implementation OAIQuery

static bool ReportQueryProgress(RankedProgress *progress, void *data)
{
    return false;
}

- initWithQuery:(NSString *)query onIndices:(NSArray *)indices maxHits:(unsigned int)max;
{
    InvertedAccessor *accessor;
    unsigned int indexListIndex;
    InvertedIndex **indexList;

    if (![super init])
        return nil;

    indexListIndex = [indices count];
    if (max == 0 || indexListIndex == 0) {
        [self release];
        return nil;
    }

    hitList = NSZoneMalloc(NULL, sizeof(RankedHit *) * max);
    indexList = NSZoneMalloc(NULL, sizeof(InvertedIndex *) * indexListIndex);
    while (indexListIndex--)
        indexList[indexListIndex] = (InvertedIndex *)[[indices objectAtIndex: indexListIndex] indexObject];
    accessor = new InvertedAccessor(indexList, [indices count]);
    accessor->Initialize();
    resultCount = accessor->RankedSearchBoolean((byte *)[query cString], [query cStringLength], (RankedHit **)hitList, max, &ReportQueryProgress, 999, NULL);

    NSZoneFree(NULL, indexList);
    delete accessor;

    return self;
}

- (unsigned int)resultCount;
{
    return resultCount;
}

- (float)scoreAtIndex:(unsigned int)index;
{
    RankedHit *hit;

    hit = hitList[index];
    return hit->GetScore();
}

- (NSString *)filenameAtIndex:(unsigned int)index;
{
    RankedHit *hit;
    UFSDirectoryDoc *doc;

    hit = hitList[index];
    doc = (UFSDirectoryDoc *)hit->GetDocument();
    return [NSString stringWithCString:(char *)(doc->GetFileName())];
}

- (NSString *)pathAtIndex:(unsigned int)index;
{
    RankedHit *hit;
    UFSDirectoryDoc *doc;
    UFSDirectoryCorpus *corpus;
    unsigned char *docName, *docPath;
    NSString *result;
    uint32 length;

    hit = hitList[index];
    doc = (UFSDirectoryDoc *)hit->GetDocument();
    docName = doc->GetFileName();
    corpus = (UFSDirectoryCorpus *)hit->GetIndex()->GetCorpus();
    docPath = corpus->GetDirectory(doc->GetDirectoryID(), &length);
    result = [NSString stringWithCString:(char *)docPath];
    result = [result stringByAppendingPathComponent:[NSString stringWithCString:(char *)docName]];
    return result;
}

- (void)dealloc;
{
    unsigned int resultIndex;

    for (resultIndex = 0; resultIndex < resultCount; resultIndex++)
        delete (RankedHit *)hitList[resultIndex];
    NSZoneFree(NULL, hitList);

    [super dealloc];
}

@end
