// Copyright 1998 Omni Development, Inc.  All rights reserved.


extern "C" {
    #import "OAIStringScanner.h"
    #import <OmniBase/rcsid.h>
    #import <Foundation/Foundation.h>
}

#import <AIAT/DocTextCharStream.h>

RCS_ID("$Header: /LocalDeveloper/Source/CVS/OmniGroup/OmniAIAT/OAIStringScanner.M,v 1.1 1998/02/26 01:54:12 toon Exp $")

@implementation OAIStringScanner

- initWithStream:(void *)aStream;
{
    [super init];
    stream = aStream;
    return self;
}

- (void)dealloc;
{
    delete (DocTextCharStream *)stream;
    [super dealloc];
}

#define BUFFER_LENGTH  8192

- (BOOL)fetchMoreData;
{
    DocTextCharStream *realStream = (DocTextCharStream *)stream;
    char buffer[BUFFER_LENGTH];
    unichar *result, *resultPtr;
    char *ptr, *end;
    unsigned int length;

    length = realStream->GetNextBuffer(buffer, BUFFER_LENGTH);
    if (!length)
        return NO;
    result = NSZoneMalloc(NULL, length * sizeof(unichar));
    ptr = buffer;
    end = buffer + length;
    resultPtr = result;
    while(ptr < end)
        *resultPtr++ = *ptr++;
    return [self fetchMoreDataFromCharacters:result length:length freeWhenDone:YES];
}

@end
