// Copyright 1998 Omni Development, Inc.  All rights reserved.

#import "OAITokenizerRegistry.h"

#import <Foundation/Foundation.h>
#import <OmniBase/rcsid.h>

#import "OAIAlphaTokenizerHolder.h"
#import "OAIObjCTokenizerHolder.h"

RCS_ID("$Header: /Network/Developer/Source/CVS/OmniGroup/OmniAIAT/OAITokenizerRegistry.m,v 1.4 1998/02/26 13:29:29 kc Exp $")

@implementation OAITokenizerRegistry

+ (OAITokenizerRegistry *)sharedRegistry;
{
    static OAITokenizerRegistry *registry = nil;

    if (!registry)
        registry = [[OAITokenizerRegistry alloc] init];
    return registry;
}

- (void)registerItemName:(NSString *)item bundle:(NSBundle *)bundle description:(NSDictionary *)description;
{
    NSArray *types;
    NSEnumerator *enumerator;
    NSString *type;
    NSMutableDictionary *info;

    types = [description objectForKey:@"extensions"];
    enumerator = [types objectEnumerator];
    while ((type = [enumerator nextObject])) {
        [typeToBundle setObject:bundle forKey:type];
    }
    info = [bundleInformation objectForKey:[bundle bundlePath]];
    if (!info) {
        info = [[NSMutableDictionary alloc] init];
        [bundleInformation setObject:info forKey:[bundle bundlePath]];
        [info release];
    }
    [info setObject:types forKey:item];
}

+ (void)registerItemName:(NSString *)item bundle:(NSBundle *)bundle description:(NSDictionary *)description;
{
    [[self sharedRegistry] registerItemName:item bundle:bundle description:description];
}


- init;
{
    OAIAlphaTokenizerHolder *alphaTokenizer;

    if (![super init])
        return nil;

    tokenizers = [[NSMutableDictionary alloc] init];
    bundleInformation = [[NSMutableDictionary alloc] init];
    typeToBundle = [[NSMutableDictionary alloc] init];
    
    alphaTokenizer = [[OAIAlphaTokenizerHolder alloc] init];

    // Plain text
    [tokenizers setObject:alphaTokenizer forKey:@""];
    [tokenizers setObject:alphaTokenizer forKey:@"txt"];
    [tokenizers setObject:alphaTokenizer forKey:@"text"];

    // Code
    [tokenizers setObject:alphaTokenizer forKey:@"h"];
    [tokenizers setObject:alphaTokenizer forKey:@"m"];

    // HTML
    // Eventually, we should write a real HTML tokenizer
    [tokenizers setObject:alphaTokenizer forKey:@"html"];

    [alphaTokenizer release];

    return self;
}

- (void)registerTokenizer:(id <OAITokenizer>)aTokenizer forExtension:(NSString *)extension;
{
    OAIObjCTokenizerHolder *holder;

    holder = [[OAIObjCTokenizerHolder alloc] initWithFactory:aTokenizer];
    [tokenizers setObject:holder forKey:extension];
    [holder release];
}

- (BOOL)hasTokenizerForExtension:(NSString *)extension;
{
    return ([tokenizers objectForKey:extension] != nil) || ([typeToBundle objectForKey:extension] != nil);
}

- (void)_loadBundle:(NSBundle *)bundle;
{
    NSDictionary *info = [bundleInformation objectForKey:[bundle bundlePath]];
    NSString *key, *type;
    NSEnumerator *enumerator = [info keyEnumerator];
    NSEnumerator *typeEnumerator;

    NSLog(@"Loading bundle: %@", [bundle bundlePath]);

    while ((key = [enumerator nextObject])) {
        Class class;
        id <OAITokenizer> instance;

        class = [bundle classNamed:key];
        if (!class || !(instance = [[class alloc] init]))
            continue;
        typeEnumerator = [[info objectForKey:key] objectEnumerator];
        while ((type = [typeEnumerator nextObject]))
            [self registerTokenizer:instance forExtension:type];
        [instance release];
    }
}

- (void *)tokenizerForExtension:(NSString *)extension withStream:(void *)stream;
{
    id <OAITokenizerHolder> tokenizer;

    tokenizer = [tokenizers objectForKey:extension];
    if (!tokenizer) {
        NSBundle *bundle = [typeToBundle objectForKey:extension];

        if (!bundle)
            return NULL;
        [self _loadBundle:bundle];
        tokenizer = [tokenizers objectForKey:extension];
    }
    return [tokenizer cppTokenizerForStream:stream];
}

@end
