/**
 * OpenAmp Application Controller
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 25, 1998
 **/

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import "Extentions.h"
#import "PlayList.h"
#import "ConsoleController.h"
#import "ApplicationController.h"

@implementation ApplicationController

/**
 * Inits
 **/

- (id) init
{
    if ((self = [super init]))
      {
        myActivePlayList    = nil;
        myConsoleController = [[ConsoleController alloc] init];
      }
    return self;
}

- (void) dealloc
{
    [ myActivePlayList    release ];
    [ myConsoleController release ];

    [super dealloc];
}

/**
 * Accessors
 **/

- (PlayList*         ) activePlayList    { return myActivePlayList   ; }
- (ConsoleController*) consoleController { return myConsoleController; }

- (void) setActivePlayList: (PlayList*) aValue
{
    setAndRetain(myActivePlayList, aValue);

    [myConsoleController setPlayList: aValue];
}

/**
 * Actions
 **/

- (PlayList*) newPlayList
{
    return [[NSDocumentController sharedDocumentController]
               openUntitledDocumentOfType: @"OpenAmpPlayList"
                                  display: YES];
}

- (void) playListDidClose: (PlayList*) aPlayList
{
    if (aPlayList == myActivePlayList) [self setActivePlayList: nil];
}

@end
