/**
 * OpenAmp Audio File
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 24, 1998
 **/

#import <AppKit/NSDocument.h>

@class NSString;
@class PlayList;

@interface AudioFile : NSDocument

{
@private
    NSString* myFileName;
    PlayList* myPlayList;
}

/**
 * Factories
 **/

+ (AudioFile*) file;

/**
 * Inits
 **/

- (id) init;

/**
 * Accessors
 **/

- (NSString*) filename;
- (NSString*) title;
- (NSString*) artist;
- (NSString*) album;
- (NSString*) copyright;
- (NSString*) info;
- (NSString*) description;

/**
 * Actions
 **/

- (BOOL) readFromFile: (NSString*) aFileName
               ofType: (NSString*) aType;
- (BOOL)  writeToFile: (NSString*) aFileName
               ofType: (NSString*) aType;

@end
