/**
 * OpenAmp Console Controller
 *
 * Wilfredo Sanchez | wsanchez@apple.com
 * September 26, 1998
 **/

#import <Foundation/NSObject.h>

@class NSLock;
@class AudioFile;
@class ConsoleController;
@class SoundStream;

@interface SoundDecoder : NSObject

{
@private
    ConsoleController* myOwner;
    NSLock*            myDecodingLock;
}

/**
 * Inits
 **/

- (id) initWithOwner: (id) anOwner;

/**
 * Actions
 **/

- (void) play: (AudioFile*) anAudioFile;
- (void) stop;
- (void) pause;
- (void) resume;
- (void) wait;

/**
 * Stream messages
 **/

- (void) done;

- (void) soundStream: (SoundStream*) aStream
      finishedBuffer: (int         ) aTag
             ofTotal: (int         ) aTotal;

@end
